/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.Query;
import io.stargate.sdk.doc.domain.QueryBuilderFilter;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class QueryBuilder {
    protected Set<String> fields = null;
    protected String whereClause;
    protected List<Filter> filters = new ArrayList<Filter>();

    public Query build() {
        return new Query(this);
    }

    public QueryBuilder select(String ... fields) {
        Assert.notNull((Object)fields, (String)"fields");
        this.fields = new HashSet<String>(Arrays.asList(fields));
        return this;
    }

    public QueryBuilder selectAll() {
        this.fields = null;
        return this;
    }

    public QueryBuilder jsonWhere(String where) {
        if (this.whereClause != null) {
            throw new IllegalArgumentException("Only a single where clause is allowed in a query");
        }
        Assert.hasLength((String)where, (String)"where");
        this.whereClause = where;
        return this;
    }

    public QueryBuilderFilter where(String fieldName) {
        Assert.hasLength((String)fieldName, (String)"fieldName");
        if (!this.filters.isEmpty()) {
            throw new IllegalArgumentException("Invalid query please use and() as a where clause has been provided");
        }
        return new QueryBuilderFilter(this, fieldName);
    }

    public QueryBuilderFilter and(String fieldName) {
        Assert.hasLength((String)fieldName, (String)"fieldName");
        if (this.filters.isEmpty()) {
            throw new IllegalArgumentException("Invalid query please use where() as you first condition");
        }
        return new QueryBuilderFilter(this, fieldName);
    }

    public String getWhereClause() {
        if (Utils.hasLength((String)this.whereClause)) {
            return this.whereClause;
        }
        return "{" + this.filters.stream().map(Filter::toString).collect(Collectors.joining(",")) + "}";
    }
}

