/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.QueryBuilder;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.http.domain.FilterCondition;
import java.util.Collection;

public class QueryBuilderFilter {
    private final String fieldName;
    private final QueryBuilder builder;

    protected QueryBuilderFilter(QueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private QueryBuilder addFilter(FilterCondition op, Object value) {
        this.builder.filters.add(new Filter(this.fieldName, op, value));
        return this.builder;
    }

    public QueryBuilder isLessThan(Object value) {
        return this.addFilter(FilterCondition.LESS_THAN, value);
    }

    public QueryBuilder isLessOrEqualsThan(Object value) {
        return this.addFilter(FilterCondition.LESS_THAN_OR_EQUALS_TO, value);
    }

    public QueryBuilder isGreaterThan(Object value) {
        return this.addFilter(FilterCondition.GREATER_THAN, value);
    }

    public QueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.addFilter(FilterCondition.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public QueryBuilder isEqualsTo(Object value) {
        return this.addFilter(FilterCondition.EQUALS_TO, value);
    }

    public QueryBuilder isNotEqualsTo(Object value) {
        return this.addFilter(FilterCondition.NOT_EQUALS_TO, value);
    }

    public QueryBuilder exists() {
        return this.addFilter(FilterCondition.EXISTS, null);
    }

    public QueryBuilder isIn(Collection<Object> values) {
        return this.addFilter(FilterCondition.IN, values);
    }
}

