/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.api.odm.RecordMapper;
import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.doc.Document;
import io.stargate.sdk.doc.DocumentClient;
import io.stargate.sdk.doc.NamespaceClient;
import io.stargate.sdk.doc.domain.CollectionDefinition;
import io.stargate.sdk.doc.domain.PageableQuery;
import io.stargate.sdk.doc.domain.Query;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import io.stargate.sdk.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionClient {
    public static final String DOCUMENT_ID = "documentId";
    public static final String BATCH_ID_PATH = "id-path";
    private final LoadBalancedHttpClient stargateHttpClient;
    protected NamespaceClient namespaceClient;
    protected String collectionName;
    private static TypeReference<ApiResponse<Map<String, LinkedHashMap<?, ?>>>> RESPONSE_SEARCH = new TypeReference<ApiResponse<Map<String, LinkedHashMap<?, ?>>>>(){};
    public Function<ServiceHttp, String> collectionResource = node -> this.namespaceClient.collectionsResource.apply((ServiceHttp)node) + "/" + this.collectionName;
    public Function<ServiceHttp, String> collectionUpgradeResource = node -> this.collectionResource.apply((ServiceHttp)node) + "/upgrade?raw=true";
    public Function<ServiceHttp, String> collectionBatchResource = node -> this.collectionResource.apply((ServiceHttp)node) + "/batch";
    public Function<ServiceHttp, String> collectionJsonSchemaResource = node -> this.collectionResource.apply((ServiceHttp)node) + "/json-schema";

    public CollectionClient(LoadBalancedHttpClient stargateHttpClient, NamespaceClient namespaceClient, String collectionName) {
        this.namespaceClient = namespaceClient;
        this.collectionName = collectionName;
        this.stargateHttpClient = stargateHttpClient;
    }

    public Optional<CollectionDefinition> find() {
        return this.namespaceClient.collections().filter(c -> this.collectionName.equalsIgnoreCase(c.getName())).findFirst();
    }

    public boolean exist() {
        return this.namespaceClient.collectionNames().anyMatch(this.collectionName::equals);
    }

    public void create() {
        this.stargateHttpClient.POST(this.collectionResource, "{\"name\":\"" + this.collectionName + "\"}");
    }

    public void upgradeSAI() {
        this.upgrade(CollectionUpgradeType.SAI_INDEX_UPGRADE);
    }

    public void upgrade(CollectionUpgradeType index) {
        this.stargateHttpClient.POST(this.collectionUpgradeResource, "{\"upgradeType\":\"" + index.name() + "\"}");
    }

    public void delete() {
        this.stargateHttpClient.DELETE(this.collectionResource);
    }

    public <DOC> String create(DOC doc) {
        ApiResponseHttp res = this.stargateHttpClient.POST(this.collectionResource, JsonUtils.marshall(doc));
        try {
            return (String)((Map)JsonUtils.unmarshallBean((String)res.getBody(), Map.class)).get(DOCUMENT_ID);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall document id", e);
        }
    }

    public String create(String doc) {
        ApiResponseHttp res = this.stargateHttpClient.POST(this.collectionResource, doc);
        try {
            return (String)((Map)JsonUtils.unmarshallBean((String)res.getBody(), Map.class)).get(DOCUMENT_ID);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall document id", e);
        }
    }

    public <DOC> List<String> batchInsert(List<DOC> records, String idPath) {
        Assert.notNull(records, (String)"Records should be provided");
        ApiResponseHttp res = Utils.hasLength((String)idPath) ? this.stargateHttpClient.POST(this.collectionBatchResource, JsonUtils.marshall(records), "?id-path=" + idPath) : this.stargateHttpClient.POST(this.collectionBatchResource, JsonUtils.marshall(records));
        Map doc = (Map)JsonUtils.unmarshallBean((String)res.getBody(), Map.class);
        if (doc.containsKey("documentIds")) {
            return (List)doc.get("documentIds");
        }
        return new ArrayList<String>();
    }

    public List<String> batchInsertRaw(List<String> records, String idPath) {
        Assert.notNull(records, (String)"Records should be provided");
        ApiResponseHttp res = Utils.hasLength((String)idPath) ? this.stargateHttpClient.POST(this.collectionBatchResource, JsonUtils.marshall(records), "?id-path=" + idPath) : this.stargateHttpClient.POST(this.collectionBatchResource, JsonUtils.marshall(records));
        Map doc = (Map)JsonUtils.unmarshallBean((String)res.getBody(), Map.class);
        if (doc.containsKey("documentIds")) {
            return (List)doc.get("documentIds");
        }
        return new ArrayList<String>();
    }

    public <DOC> List<String> batchInsert(List<DOC> records) {
        return this.batchInsert(records, null);
    }

    public List<String> batchInsertRaw(List<String> records) {
        return this.batchInsert(records, null);
    }

    public long count() {
        return this.findAll(Query.builder().select("field_not_exist").build()).count();
    }

    public Stream<Document<String>> findAll() {
        return this.findAll(Query.builder().build());
    }

    public <DOC> Stream<Document<DOC>> findAll(RecordMapper<DOC> documentMapper) {
        return this.findAll(Query.builder().build(), documentMapper);
    }

    public <DOC> Stream<Document<DOC>> findAll(Class<DOC> beanClass) {
        return this.findAll(Query.builder().build(), beanClass);
    }

    public Stream<Document<String>> findAll(Query query) {
        return this.findAll(query, (CollectionClient cc, PageableQuery q) -> cc.findPage(q));
    }

    public <DOC> Stream<Document<DOC>> findAll(Query query, RecordMapper<DOC> documentMapper) {
        return this.findAll(query, (CollectionClient cc, PageableQuery q) -> cc.findPage(q, documentMapper));
    }

    public <DOC> Stream<Document<DOC>> findAll(Query query, Class<DOC> beanClass) {
        return this.findAll(query, (CollectionClient cc, PageableQuery q) -> cc.findPage(q, beanClass));
    }

    private <DOC> Stream<Document<DOC>> findAll(Query query, PageSupplier<DOC> pageLoader) {
        ArrayList documents = new ArrayList();
        PageableQuery pageQuery = new PageableQuery(query);
        String pageState = null;
        do {
            Page<Document<DOC>> pageX;
            pageState = (pageX = pageLoader.findPage(this, pageQuery)).getPageState().isPresent() ? (String)pageX.getPageState().get() : null;
            documents.addAll(pageX.getResults());
            pageQuery.setPageState(pageState);
        } while (pageState != null);
        return documents.stream();
    }

    public Page<Document<String>> findPage() {
        return this.findPage(PageableQuery.builder().build());
    }

    public Page<Document<String>> findPage(PageableQuery query) {
        ApiResponse<Map<String, LinkedHashMap<?, ?>>> searchResults = this.httpGetFindPage(query);
        if (null != searchResults && null != searchResults.getData()) {
            return new Page(query.getPageSize(), searchResults.getPageState(), ((Map)searchResults.getData()).entrySet().stream().map(doc -> new Document<String>((String)doc.getKey(), JsonUtils.marshall(doc.getValue()))).collect(Collectors.toList()));
        }
        return new Page();
    }

    public <DOC> Page<Document<DOC>> findPage(Class<DOC> beanClass) {
        return this.findPage(PageableQuery.builder().build(), beanClass);
    }

    public <DOC> Page<Document<DOC>> findPage(PageableQuery query, Class<DOC> beanClass) {
        ApiResponse<Map<String, LinkedHashMap<?, ?>>> searchResults = this.httpGetFindPage(query);
        if (null != searchResults && null != searchResults.getData()) {
            return new Page(query.getPageSize(), searchResults.getPageState(), ((Map)searchResults.getData()).entrySet().stream().map(doc -> new Document<Object>((String)doc.getKey(), JsonUtils.getObjectMapper().convertValue(doc.getValue(), beanClass))).collect(Collectors.toList()));
        }
        return new Page();
    }

    public <DOC> Page<Document<DOC>> findPage(RecordMapper<DOC> documentMapper) {
        return this.findPage(PageableQuery.builder().build(), documentMapper);
    }

    public <DOC> Page<Document<DOC>> findPage(PageableQuery query, RecordMapper<DOC> documentMapper) {
        Page<Document<String>> raw = this.findPage(query);
        return new Page(raw.getPageSize(), (String)raw.getPageState().orElse(null), raw.getResults().stream().map(doc -> new Document<Object>(doc.getDocumentId(), documentMapper.map((String)doc.getDocument()))).collect(Collectors.toList()));
    }

    private ApiResponse<Map<String, LinkedHashMap<?, ?>>> httpGetFindPage(PageableQuery query) {
        try {
            return (ApiResponse)JsonUtils.unmarshallType((String)this.stargateHttpClient.GET(this.collectionResource, this.buildSuffixQueryUrl(query)).getBody(), RESPONSE_SEARCH);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall document results", e);
        }
    }

    private String buildSuffixQueryUrl(PageableQuery query) {
        try {
            StringBuilder sbUrl = new StringBuilder();
            sbUrl.append("?page-size=" + query.getPageSize());
            if (query.getPageState().isPresent()) {
                sbUrl.append("&page-state=" + URLEncoder.encode(query.getPageState().get(), StandardCharsets.UTF_8.toString()));
            }
            if (query.getWhere().isPresent()) {
                sbUrl.append("&where=" + URLEncoder.encode(query.getWhere().get(), StandardCharsets.UTF_8.toString()));
            }
            if (query.getFieldsToRetrieve().isPresent() && !query.getFieldsToRetrieve().get().isEmpty()) {
                sbUrl.append("&fields=" + URLEncoder.encode(JsonUtils.collectionAsJson((Collection)query.getFieldsToRetrieve().get()), StandardCharsets.UTF_8.toString()));
            }
            return sbUrl.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot enode URL", e);
        }
    }

    public DocumentClient document(String docId) {
        return new DocumentClient(this.stargateHttpClient, this, docId);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public static enum CollectionUpgradeType {
        SAI_INDEX_UPGRADE;

    }

    public static interface PageSupplier<DOC> {
        public Page<Document<DOC>> findPage(CollectionClient var1, PageableQuery var2);
    }
}

