/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import io.stargate.sdk.api.odm.RecordMapper;
import io.stargate.sdk.doc.CollectionClient;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DocumentClient {
    private final LoadBalancedHttpClient stargateHttpClient;
    private CollectionClient collectionClient;
    private String docId;
    public Function<ServiceHttp, String> documentResource = node -> this.collectionClient.collectionResource.apply((ServiceHttp)node) + "/" + this.docId;

    public DocumentClient(LoadBalancedHttpClient stargateHttpClient, CollectionClient collectionClient, String docId) {
        this.collectionClient = collectionClient;
        this.docId = docId;
        this.stargateHttpClient = stargateHttpClient;
    }

    public boolean exist() {
        return 200 == this.stargateHttpClient.GET(this.documentResource).getCode();
    }

    public <DOC> String upsert(DOC doc) {
        Assert.notNull(doc, (String)"document");
        ApiResponseHttp res = this.stargateHttpClient.PUT(this.documentResource, JsonUtils.marshall(doc));
        return this.marshallDocumentId(res.getBody());
    }

    public String upsert(String json) {
        Assert.hasLength((String)json, (String)"Json document should not be null");
        ApiResponseHttp res = this.stargateHttpClient.PUT(this.documentResource, json);
        return this.marshallDocumentId(res.getBody());
    }

    public <DOC> String update(DOC doc) {
        Assert.notNull(doc, (String)"document");
        ApiResponseHttp res = this.stargateHttpClient.PATCH(this.documentResource, JsonUtils.marshall(doc));
        return this.marshallDocumentId(res.getBody());
    }

    public String update(String json) {
        Assert.hasLength((String)json, (String)"Json document should not be null");
        ApiResponseHttp res = this.stargateHttpClient.PATCH(this.documentResource, json);
        return this.marshallDocumentId(res.getBody());
    }

    public Optional<String> find() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.documentResource, "?raw=true");
        if (200 == res.getCode()) {
            return Optional.of(res.getBody());
        }
        return Optional.empty();
    }

    public <DOC> Optional<DOC> find(RecordMapper<DOC> docm) {
        Assert.notNull(docm, (String)"documentMapper");
        Optional<String> f = this.find();
        if (f.isPresent()) {
            return f.map(arg_0 -> docm.map(arg_0));
        }
        return Optional.empty();
    }

    public <DOC> Optional<DOC> find(Class<DOC> clazz) {
        Assert.notNull(clazz, (String)"className");
        Optional<String> f = this.find();
        if (f.isPresent()) {
            return f.map(b -> this.marshallDocument((String)b, clazz));
        }
        return Optional.empty();
    }

    public void delete() {
        if (!this.exist()) {
            throw new IllegalArgumentException("Cannot delete " + this.docId + ", it does not exists");
        }
        this.stargateHttpClient.DELETE(this.documentResource);
    }

    private String formatPath(String path) {
        Assert.hasLength((String)path, (String)"hasLength");
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public <SUBDOC> Optional<SUBDOC> findSubDocument(String path, Class<SUBDOC> className) {
        Assert.notNull(className, (String)"expectedClass");
        Assert.hasLength((String)path, (String)"path");
        ApiResponseHttp res = this.stargateHttpClient.GET(this.documentResource, this.formatPath(path) + "?raw=true");
        if (200 == res.getCode()) {
            return Optional.of(this.marshallDocument(res.getBody(), className));
        }
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<String> findSubDocument(String path) {
        Assert.hasLength((String)path, (String)"path");
        ApiResponseHttp res = this.stargateHttpClient.GET(this.documentResource, this.formatPath(path) + "?raw=true");
        if (200 == res.getCode()) {
            return Optional.of(res.getBody());
        }
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String executefunction(String path, String function, Object value) {
        ApiResponseHttp res;
        Map doc;
        if (value instanceof String) {
            value = "\"" + String.valueOf(value) + "\"";
        }
        if ((doc = (Map)JsonUtils.unmarshallBean((String)(res = this.stargateHttpClient.POST(this.documentResource, "{ \"operation\":\"" + function + "\",\"value\":" + JsonUtils.marshall((Object)value) + "}", this.formatPath(path) + "/function")).getBody(), Map.class)).containsKey("data")) {
            return JsonUtils.marshall(doc.get("data"));
        }
        return res.getBody();
    }

    public <SUBDOC> void replaceSubDocument(String path, SUBDOC newValue) {
        Assert.notNull(newValue, (String)"newValue");
        this.stargateHttpClient.PUT(this.documentResource, JsonUtils.marshall(newValue), this.formatPath(path));
    }

    public void replaceSubDocument(String path, String newValue) {
        Assert.hasLength((String)path, (String)"path");
        Assert.hasLength((String)newValue, (String)"newValue");
        this.stargateHttpClient.PUT(this.documentResource, newValue, this.formatPath(path));
    }

    public <SUBDOC> void updateSubDocument(String path, SUBDOC newValue) {
        Assert.notNull(newValue, (String)"newValue");
        this.stargateHttpClient.PATCH(this.documentResource, JsonUtils.marshall(newValue), this.formatPath(path));
    }

    public void updateSubDocument(String path, String newValue) {
        Assert.hasLength((String)path, (String)"path");
        Assert.hasLength((String)newValue, (String)"newValue");
        this.stargateHttpClient.PATCH(this.documentResource, newValue, this.formatPath(path));
    }

    public void deleteSubDocument(String path) {
        this.stargateHttpClient.DELETE(this.documentResource, this.formatPath(path) + "?raw=true");
    }

    private String marshallDocumentId(String body) {
        try {
            return (String)((Map)JsonUtils.unmarshallBean((String)body, Map.class)).get("documentId");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshall document after 'upsert'", e);
        }
    }

    private <SUBDOC> SUBDOC marshallDocument(String body, Class<SUBDOC> clazz) {
        try {
            if (clazz.equals(String.class)) {
                return (SUBDOC)body;
            }
            return (SUBDOC)JsonUtils.unmarshallBean((String)body, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot marshal output '" + body + "' into class '" + String.valueOf(clazz) + "'", e);
        }
    }
}

