/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import io.stargate.sdk.doc.CollectionClient;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StargateDocumentDataLoader<DOC>
implements Closeable {
    private static final int DEFAULT_POOL_SIZE = 6;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ExecutorService executor;

    public StargateDocumentDataLoader() {
        this(6);
    }

    public StargateDocumentDataLoader(int poolSize) {
        this.executor = Executors.newFixedThreadPool(poolSize);
    }

    public CompletableFuture<Void> submitCreateDoc(CollectionClient ccc, DOC doc) {
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            ccc.create(doc);
            this.lock.writeLock().unlock();
        }, this.executor);
    }

    public CompletableFuture<Void> submitCreateDoc(CollectionClient ccc, String doc) {
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            ccc.create(doc);
            this.lock.writeLock().unlock();
        }, this.executor);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

