/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.PageableQueryBuilder;
import io.stargate.sdk.doc.domain.Query;
import java.util.Optional;
import java.util.Set;

public class PageableQuery {
    public static final int PAGING_SIZE_MAX = 20;
    public static final int DEFAULT_PAGING_SIZE = 20;
    protected Set<String> fieldsToRetrieve;
    protected String where;
    private int pageSize = 20;
    private String pageState;

    public PageableQuery(Query query) {
        this.fieldsToRetrieve = query.fieldsToRetrieve;
        this.where = query.where;
        this.pageSize = 20;
        this.pageState = null;
    }

    public PageableQuery(PageableQueryBuilder builder) {
        this.fieldsToRetrieve = builder.fields;
        this.where = builder.getWhereClause();
        this.pageSize = builder.getPageSize();
        this.pageState = builder.getPageState();
    }

    public static PageableQueryBuilder builder() {
        return new PageableQueryBuilder();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }

    public void setPageState(String pageState) {
        this.pageState = pageState;
    }

    public Optional<String> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public Optional<Set<String>> getFieldsToRetrieve() {
        return Optional.ofNullable(this.fieldsToRetrieve);
    }
}

