/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.PageableQuery;
import io.stargate.sdk.doc.domain.PageableQueryBuilderFilter;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PageableQueryBuilder {
    protected Set<String> fields = null;
    protected String whereClause;
    protected List<Filter> filters = new ArrayList<Filter>();
    protected int pageSize = 20;
    protected String pageState = null;

    public PageableQueryBuilder pageSize(int pageSize) {
        if (pageSize < 1 || pageSize > 20) {
            throw new IllegalArgumentException("Page size should be between 1 and 20");
        }
        this.pageSize = pageSize;
        return this;
    }

    public PageableQueryBuilder pageState(String pageState) {
        Assert.hasLength((String)pageState, (String)"pageState");
        this.pageState = pageState;
        return this;
    }

    public PageableQueryBuilder select(String ... fields) {
        Assert.notNull((Object)fields, (String)"fields");
        this.fields = new HashSet<String>(Arrays.asList(fields));
        return this;
    }

    public PageableQueryBuilder selectAll() {
        this.fields = null;
        return this;
    }

    public PageableQueryBuilder jsonWhere(String where) {
        if (this.whereClause != null) {
            throw new IllegalArgumentException("Only a single where clause is allowed in a query");
        }
        Assert.hasLength((String)where, (String)"where");
        this.whereClause = where;
        return this;
    }

    public PageableQueryBuilderFilter where(String fieldName) {
        Assert.hasLength((String)fieldName, (String)"fieldName");
        if (!this.filters.isEmpty()) {
            throw new IllegalArgumentException("Invalid query please use and() as a where clause has been provided");
        }
        return new PageableQueryBuilderFilter(this, fieldName);
    }

    public PageableQueryBuilderFilter and(String fieldName) {
        Assert.hasLength((String)fieldName, (String)"fieldName");
        if (this.filters.isEmpty()) {
            throw new IllegalArgumentException("Invalid query please use where() as you first condition");
        }
        return new PageableQueryBuilderFilter(this, fieldName);
    }

    public String getWhereClause() {
        if (Utils.hasLength((String)this.whereClause)) {
            return this.whereClause;
        }
        return "{" + this.filters.stream().map(Filter::toString).collect(Collectors.joining(",")) + "}";
    }

    public PageableQuery build() {
        return new PageableQuery(this);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getPageState() {
        return this.pageState;
    }
}

