/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.PageableQueryBuilder;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.Collection;

public class PageableQueryBuilderFilter {
    private final String fieldName;
    private final PageableQueryBuilder builder;

    protected PageableQueryBuilderFilter(PageableQueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private PageableQueryBuilder addFilter(FilterOperator op, Object value) {
        this.builder.filters.add(new Filter(this.fieldName, op, value));
        return this.builder;
    }

    public PageableQueryBuilder isLessThan(Object value) {
        return this.addFilter(FilterOperator.LESS_THAN, value);
    }

    public PageableQueryBuilder isLessOrEqualsThan(Object value) {
        return this.addFilter(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public PageableQueryBuilder isGreaterThan(Object value) {
        return this.addFilter(FilterOperator.GREATER_THAN, value);
    }

    public PageableQueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.addFilter(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public PageableQueryBuilder isEqualsTo(Object value) {
        return this.addFilter(FilterOperator.EQUALS_TO, value);
    }

    public PageableQueryBuilder isNotEqualsTo(Object value) {
        return this.addFilter(FilterOperator.NOT_EQUALS_TO, value);
    }

    public PageableQueryBuilder exists() {
        return this.addFilter(FilterOperator.EXISTS, null);
    }

    public PageableQueryBuilder isIn(Collection<Object> values) {
        return this.addFilter(FilterOperator.IN, values);
    }
}

