package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import io.stargate.graphql.types.ColumnInput;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlterTableAddGraphQLQuery extends GraphQLQuery {
  public AlterTableAddGraphQLQuery(String keyspaceName, String tableName, List<ColumnInput> toAdd,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (tableName != null || fieldsSet.contains("tableName")) {
        getInput().put("tableName", tableName);
    }if (toAdd != null || fieldsSet.contains("toAdd")) {
        getInput().put("toAdd", toAdd);
    }
  }

  public AlterTableAddGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "alterTableAdd";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String tableName;

    private List<ColumnInput> toAdd;

    public AlterTableAddGraphQLQuery build() {
      return new AlterTableAddGraphQLQuery(keyspaceName, tableName, toAdd, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder tableName(String tableName) {
      this.tableName = tableName;
      this.fieldsSet.add("tableName");
      return this;
    }

    public Builder toAdd(List<ColumnInput> toAdd) {
      this.toAdd = toAdd;
      this.fieldsSet.add("toAdd");
      return this;
    }
  }
}
