package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlterTableDropGraphQLQuery extends GraphQLQuery {
  public AlterTableDropGraphQLQuery(String keyspaceName, String tableName, List<String> toDrop,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (tableName != null || fieldsSet.contains("tableName")) {
        getInput().put("tableName", tableName);
    }if (toDrop != null || fieldsSet.contains("toDrop")) {
        getInput().put("toDrop", toDrop);
    }
  }

  public AlterTableDropGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "alterTableDrop";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String tableName;

    private List<String> toDrop;

    public AlterTableDropGraphQLQuery build() {
      return new AlterTableDropGraphQLQuery(keyspaceName, tableName, toDrop, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder tableName(String tableName) {
      this.tableName = tableName;
      this.fieldsSet.add("tableName");
      return this;
    }

    public Builder toDrop(List<String> toDrop) {
      this.toDrop = toDrop;
      this.fieldsSet.add("toDrop");
      return this;
    }
  }
}
