package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import io.stargate.graphql.types.IndexKind;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateIndexGraphQLQuery extends GraphQLQuery {
  public CreateIndexGraphQLQuery(String keyspaceName, String tableName, String columnName,
      String indexName, String indexType, Boolean ifNotExists, IndexKind indexKind,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (tableName != null || fieldsSet.contains("tableName")) {
        getInput().put("tableName", tableName);
    }if (columnName != null || fieldsSet.contains("columnName")) {
        getInput().put("columnName", columnName);
    }if (indexName != null || fieldsSet.contains("indexName")) {
        getInput().put("indexName", indexName);
    }if (indexType != null || fieldsSet.contains("indexType")) {
        getInput().put("indexType", indexType);
    }if (ifNotExists != null || fieldsSet.contains("ifNotExists")) {
        getInput().put("ifNotExists", ifNotExists);
    }if (indexKind != null || fieldsSet.contains("indexKind")) {
        getInput().put("indexKind", indexKind);
    }
  }

  public CreateIndexGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "createIndex";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String tableName;

    private String columnName;

    private String indexName;

    private String indexType;

    private Boolean ifNotExists;

    private IndexKind indexKind;

    public CreateIndexGraphQLQuery build() {
      return new CreateIndexGraphQLQuery(keyspaceName, tableName, columnName, indexName, indexType, ifNotExists, indexKind, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder tableName(String tableName) {
      this.tableName = tableName;
      this.fieldsSet.add("tableName");
      return this;
    }

    public Builder columnName(String columnName) {
      this.columnName = columnName;
      this.fieldsSet.add("columnName");
      return this;
    }

    public Builder indexName(String indexName) {
      this.indexName = indexName;
      this.fieldsSet.add("indexName");
      return this;
    }

    public Builder indexType(String indexType) {
      this.indexType = indexType;
      this.fieldsSet.add("indexType");
      return this;
    }

    public Builder ifNotExists(Boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
      this.fieldsSet.add("ifNotExists");
      return this;
    }

    public Builder indexKind(IndexKind indexKind) {
      this.indexKind = indexKind;
      this.fieldsSet.add("indexKind");
      return this;
    }
  }
}
