package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import io.stargate.graphql.types.DataCenterInput;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CreateKeyspaceGraphQLQuery extends GraphQLQuery {
  public CreateKeyspaceGraphQLQuery(String name, Boolean ifNotExists, Integer replicas,
      List<DataCenterInput> datacenters, Set<String> fieldsSet) {
    super("mutation");
    if (name != null || fieldsSet.contains("name")) {
        getInput().put("name", name);
    }if (ifNotExists != null || fieldsSet.contains("ifNotExists")) {
        getInput().put("ifNotExists", ifNotExists);
    }if (replicas != null || fieldsSet.contains("replicas")) {
        getInput().put("replicas", replicas);
    }if (datacenters != null || fieldsSet.contains("datacenters")) {
        getInput().put("datacenters", datacenters);
    }
  }

  public CreateKeyspaceGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "createKeyspace";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String name;

    private Boolean ifNotExists;

    private Integer replicas;

    private List<DataCenterInput> datacenters;

    public CreateKeyspaceGraphQLQuery build() {
      return new CreateKeyspaceGraphQLQuery(name, ifNotExists, replicas, datacenters, fieldsSet);
               
    }

    public Builder name(String name) {
      this.name = name;
      this.fieldsSet.add("name");
      return this;
    }

    public Builder ifNotExists(Boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
      this.fieldsSet.add("ifNotExists");
      return this;
    }

    public Builder replicas(Integer replicas) {
      this.replicas = replicas;
      this.fieldsSet.add("replicas");
      return this;
    }

    public Builder datacenters(List<DataCenterInput> datacenters) {
      this.datacenters = datacenters;
      this.fieldsSet.add("datacenters");
      return this;
    }
  }
}
