package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import io.stargate.graphql.types.ColumnInput;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CreateTypeGraphQLQuery extends GraphQLQuery {
  public CreateTypeGraphQLQuery(String keyspaceName, String typeName, List<ColumnInput> fields,
      Boolean ifNotExists, Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (typeName != null || fieldsSet.contains("typeName")) {
        getInput().put("typeName", typeName);
    }if (fields != null || fieldsSet.contains("fields")) {
        getInput().put("fields", fields);
    }if (ifNotExists != null || fieldsSet.contains("ifNotExists")) {
        getInput().put("ifNotExists", ifNotExists);
    }
  }

  public CreateTypeGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "createType";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String typeName;

    private List<ColumnInput> fields;

    private Boolean ifNotExists;

    public CreateTypeGraphQLQuery build() {
      return new CreateTypeGraphQLQuery(keyspaceName, typeName, fields, ifNotExists, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder typeName(String typeName) {
      this.typeName = typeName;
      this.fieldsSet.add("typeName");
      return this;
    }

    public Builder fields(List<ColumnInput> fields) {
      this.fields = fields;
      this.fieldsSet.add("fields");
      return this;
    }

    public Builder ifNotExists(Boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
      this.fieldsSet.add("ifNotExists");
      return this;
    }
  }
}
