package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DropIndexGraphQLQuery extends GraphQLQuery {
  public DropIndexGraphQLQuery(String keyspaceName, String indexName, Boolean ifExists,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (indexName != null || fieldsSet.contains("indexName")) {
        getInput().put("indexName", indexName);
    }if (ifExists != null || fieldsSet.contains("ifExists")) {
        getInput().put("ifExists", ifExists);
    }
  }

  public DropIndexGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "dropIndex";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String indexName;

    private Boolean ifExists;

    public DropIndexGraphQLQuery build() {
      return new DropIndexGraphQLQuery(keyspaceName, indexName, ifExists, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder indexName(String indexName) {
      this.indexName = indexName;
      this.fieldsSet.add("indexName");
      return this;
    }

    public Builder ifExists(Boolean ifExists) {
      this.ifExists = ifExists;
      this.fieldsSet.add("ifExists");
      return this;
    }
  }
}
