package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DropKeyspaceGraphQLQuery extends GraphQLQuery {
  public DropKeyspaceGraphQLQuery(String name, Boolean ifExists, Set<String> fieldsSet) {
    super("mutation");
    if (name != null || fieldsSet.contains("name")) {
        getInput().put("name", name);
    }if (ifExists != null || fieldsSet.contains("ifExists")) {
        getInput().put("ifExists", ifExists);
    }
  }

  public DropKeyspaceGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "dropKeyspace";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String name;

    private Boolean ifExists;

    public DropKeyspaceGraphQLQuery build() {
      return new DropKeyspaceGraphQLQuery(name, ifExists, fieldsSet);
               
    }

    public Builder name(String name) {
      this.name = name;
      this.fieldsSet.add("name");
      return this;
    }

    public Builder ifExists(Boolean ifExists) {
      this.ifExists = ifExists;
      this.fieldsSet.add("ifExists");
      return this;
    }
  }
}
