package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DropTableGraphQLQuery extends GraphQLQuery {
  public DropTableGraphQLQuery(String keyspaceName, String tableName, Boolean ifExists,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (tableName != null || fieldsSet.contains("tableName")) {
        getInput().put("tableName", tableName);
    }if (ifExists != null || fieldsSet.contains("ifExists")) {
        getInput().put("ifExists", ifExists);
    }
  }

  public DropTableGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "dropTable";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String tableName;

    private Boolean ifExists;

    public DropTableGraphQLQuery build() {
      return new DropTableGraphQLQuery(keyspaceName, tableName, ifExists, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder tableName(String tableName) {
      this.tableName = tableName;
      this.fieldsSet.add("tableName");
      return this;
    }

    public Builder ifExists(Boolean ifExists) {
      this.ifExists = ifExists;
      this.fieldsSet.add("ifExists");
      return this;
    }
  }
}
