package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DropTypeGraphQLQuery extends GraphQLQuery {
  public DropTypeGraphQLQuery(String keyspaceName, String typeName, Boolean ifExists,
      Set<String> fieldsSet) {
    super("mutation");
    if (keyspaceName != null || fieldsSet.contains("keyspaceName")) {
        getInput().put("keyspaceName", keyspaceName);
    }if (typeName != null || fieldsSet.contains("typeName")) {
        getInput().put("typeName", typeName);
    }if (ifExists != null || fieldsSet.contains("ifExists")) {
        getInput().put("ifExists", ifExists);
    }
  }

  public DropTypeGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
     return "dropType";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String keyspaceName;

    private String typeName;

    private Boolean ifExists;

    public DropTypeGraphQLQuery build() {
      return new DropTypeGraphQLQuery(keyspaceName, typeName, ifExists, fieldsSet);
               
    }

    public Builder keyspaceName(String keyspaceName) {
      this.keyspaceName = keyspaceName;
      this.fieldsSet.add("keyspaceName");
      return this;
    }

    public Builder typeName(String typeName) {
      this.typeName = typeName;
      this.fieldsSet.add("typeName");
      return this;
    }

    public Builder ifExists(Boolean ifExists) {
      this.ifExists = ifExists;
      this.fieldsSet.add("ifExists");
      return this;
    }
  }
}
