package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class KeyspaceGraphQLQuery extends GraphQLQuery {
  public KeyspaceGraphQLQuery(String name, Set<String> fieldsSet) {
    super("query");
    if (name != null || fieldsSet.contains("name")) {
        getInput().put("name", name);
    }
  }

  public KeyspaceGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
     return "keyspace";
                    
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String name;

    public KeyspaceGraphQLQuery build() {
      return new KeyspaceGraphQLQuery(name, fieldsSet);
               
    }

    public Builder name(String name) {
      this.name = name;
      this.fieldsSet.add("name");
      return this;
    }
  }
}
