package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.BaseProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class KeyspaceProjectionRoot extends BaseProjectionNode {
  public Keyspace_DcsProjection dcs() {
    Keyspace_DcsProjection projection = new Keyspace_DcsProjection(this, this);    
    getFields().put("dcs", projection);
    return projection;
  }

  public Keyspace_TableProjection table() {
    Keyspace_TableProjection projection = new Keyspace_TableProjection(this, this);    
    getFields().put("table", projection);
    return projection;
  }

  public Keyspace_TableProjection table(String name) {
    Keyspace_TableProjection projection = new Keyspace_TableProjection(this, this);    
    getFields().put("table", projection);
    getInputArguments().computeIfAbsent("table", k -> new ArrayList<>());                      
    InputArgument nameArg = new InputArgument("name", name);
    getInputArguments().get("table").add(nameArg);
    return projection;
  }

  public Keyspace_TablesProjection tables() {
    Keyspace_TablesProjection projection = new Keyspace_TablesProjection(this, this);    
    getFields().put("tables", projection);
    return projection;
  }

  public Keyspace_TypeProjection type() {
    Keyspace_TypeProjection projection = new Keyspace_TypeProjection(this, this);    
    getFields().put("type", projection);
    return projection;
  }

  public Keyspace_TypeProjection type(String name) {
    Keyspace_TypeProjection projection = new Keyspace_TypeProjection(this, this);    
    getFields().put("type", projection);
    getInputArguments().computeIfAbsent("type", k -> new ArrayList<>());                      
    InputArgument nameArg = new InputArgument("name", name);
    getInputArguments().get("type").add(nameArg);
    return projection;
  }

  public Keyspace_TypesProjection types() {
    Keyspace_TypesProjection projection = new Keyspace_TypesProjection(this, this);    
    getFields().put("types", projection);
    return projection;
  }

  public KeyspaceProjectionRoot name() {
    getFields().put("name", null);
    return this;
  }
}
