package io.stargate.graphql.client;

import com.netflix.graphql.dgs.client.codegen.BaseProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class KeyspacesProjectionRoot extends BaseProjectionNode {
  public Keyspaces_DcsProjection dcs() {
    Keyspaces_DcsProjection projection = new Keyspaces_DcsProjection(this, this);    
    getFields().put("dcs", projection);
    return projection;
  }

  public Keyspaces_TableProjection table() {
    Keyspaces_TableProjection projection = new Keyspaces_TableProjection(this, this);    
    getFields().put("table", projection);
    return projection;
  }

  public Keyspaces_TableProjection table(String name) {
    Keyspaces_TableProjection projection = new Keyspaces_TableProjection(this, this);    
    getFields().put("table", projection);
    getInputArguments().computeIfAbsent("table", k -> new ArrayList<>());                      
    InputArgument nameArg = new InputArgument("name", name);
    getInputArguments().get("table").add(nameArg);
    return projection;
  }

  public Keyspaces_TablesProjection tables() {
    Keyspaces_TablesProjection projection = new Keyspaces_TablesProjection(this, this);    
    getFields().put("tables", projection);
    return projection;
  }

  public Keyspaces_TypeProjection type() {
    Keyspaces_TypeProjection projection = new Keyspaces_TypeProjection(this, this);    
    getFields().put("type", projection);
    return projection;
  }

  public Keyspaces_TypeProjection type(String name) {
    Keyspaces_TypeProjection projection = new Keyspaces_TypeProjection(this, this);    
    getFields().put("type", projection);
    getInputArguments().computeIfAbsent("type", k -> new ArrayList<>());                      
    InputArgument nameArg = new InputArgument("name", name);
    getInputArguments().get("type").add(nameArg);
    return projection;
  }

  public Keyspaces_TypesProjection types() {
    Keyspaces_TypesProjection projection = new Keyspaces_TypesProjection(this, this);    
    getFields().put("types", projection);
    return projection;
  }

  public KeyspacesProjectionRoot name() {
    getFields().put("name", null);
    return this;
  }
}
