package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class ClusteringKeyInput {
  private String name;

  private DataTypeInput type;

  private String order;

  public ClusteringKeyInput() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataTypeInput getType() {
    return type;
  }

  public void setType(DataTypeInput type) {
    this.type = type;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }

  @Override
  public String toString() {
    return "ClusteringKeyInput{" + "name='" + name + "'," +"type='" + type + "'," +"order='" + order + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusteringKeyInput that = (ClusteringKeyInput) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(type, that.type) &&
                            java.util.Objects.equals(order, that.order);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, type, order);
  }

  public static io.stargate.graphql.types.ClusteringKeyInput.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private DataTypeInput type;

    private String order;

    public ClusteringKeyInput build() {
                  io.stargate.graphql.types.ClusteringKeyInput result = new io.stargate.graphql.types.ClusteringKeyInput();
                      result.name = this.name;
          result.type = this.type;
          result.order = this.order;
                      return result;
    }

    public io.stargate.graphql.types.ClusteringKeyInput.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.ClusteringKeyInput.Builder type(DataTypeInput type) {
      this.type = type;
      return this;
    }

    public io.stargate.graphql.types.ClusteringKeyInput.Builder order(String order) {
      this.order = order;
      return this;
    }
  }
}
