package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class Column {
  private ColumnKind kind;

  private String name;

  private DataType type;

  public Column() {
  }

  public ColumnKind getKind() {
    return kind;
  }

  public void setKind(ColumnKind kind) {
    this.kind = kind;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataType getType() {
    return type;
  }

  public void setType(DataType type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "Column{" + "kind='" + kind + "'," +"name='" + name + "'," +"type='" + type + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Column that = (Column) o;
        return java.util.Objects.equals(kind, that.kind) &&
                            java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(kind, name, type);
  }

  public static io.stargate.graphql.types.Column.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ColumnKind kind;

    private String name;

    private DataType type;

    public Column build() {
                  io.stargate.graphql.types.Column result = new io.stargate.graphql.types.Column();
                      result.kind = this.kind;
          result.name = this.name;
          result.type = this.type;
                      return result;
    }

    public io.stargate.graphql.types.Column.Builder kind(ColumnKind kind) {
      this.kind = kind;
      return this;
    }

    public io.stargate.graphql.types.Column.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.Column.Builder type(DataType type) {
      this.type = type;
      return this;
    }
  }
}
