package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class ColumnInput {
  private String name;

  private DataTypeInput type;

  public ColumnInput() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataTypeInput getType() {
    return type;
  }

  public void setType(DataTypeInput type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ColumnInput{" + "name='" + name + "'," +"type='" + type + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ColumnInput that = (ColumnInput) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, type);
  }

  public static io.stargate.graphql.types.ColumnInput.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private DataTypeInput type;

    public ColumnInput build() {
                  io.stargate.graphql.types.ColumnInput result = new io.stargate.graphql.types.ColumnInput();
                      result.name = this.name;
          result.type = this.type;
                      return result;
    }

    public io.stargate.graphql.types.ColumnInput.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.ColumnInput.Builder type(DataTypeInput type) {
      this.type = type;
      return this;
    }
  }
}
