package io.stargate.graphql.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class DataCenter {
  private String name;

  private Integer replicas;

  public DataCenter() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getReplicas() {
    return replicas;
  }

  public void setReplicas(Integer replicas) {
    this.replicas = replicas;
  }

  @Override
  public String toString() {
    return "DataCenter{" + "name='" + name + "'," +"replicas='" + replicas + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DataCenter that = (DataCenter) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(replicas, that.replicas);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, replicas);
  }

  public static io.stargate.graphql.types.DataCenter.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Integer replicas;

    public DataCenter build() {
                  io.stargate.graphql.types.DataCenter result = new io.stargate.graphql.types.DataCenter();
                      result.name = this.name;
          result.replicas = this.replicas;
                      return result;
    }

    public io.stargate.graphql.types.DataCenter.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.DataCenter.Builder replicas(Integer replicas) {
      this.replicas = replicas;
      return this;
    }
  }
}
