package io.stargate.graphql.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class DataCenterInput {
  private String name;

  private Integer replicas;

  public DataCenterInput() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getReplicas() {
    return replicas;
  }

  public void setReplicas(Integer replicas) {
    this.replicas = replicas;
  }

  @Override
  public String toString() {
    return "DataCenterInput{" + "name='" + name + "'," +"replicas='" + replicas + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DataCenterInput that = (DataCenterInput) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(replicas, that.replicas);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, replicas);
  }

  public static io.stargate.graphql.types.DataCenterInput.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Integer replicas;

    public DataCenterInput build() {
                  io.stargate.graphql.types.DataCenterInput result = new io.stargate.graphql.types.DataCenterInput();
                      result.name = this.name;
          result.replicas = this.replicas;
                      return result;
    }

    public io.stargate.graphql.types.DataCenterInput.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.DataCenterInput.Builder replicas(Integer replicas) {
      this.replicas = replicas;
      return this;
    }
  }
}
