package io.stargate.graphql.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;

public class DataTypeInfo {
  private String name;

  private List<DataType> subTypes;

  private Boolean frozen;

  public DataTypeInfo() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<DataType> getSubTypes() {
    return subTypes;
  }

  public void setSubTypes(List<DataType> subTypes) {
    this.subTypes = subTypes;
  }

  public Boolean getFrozen() {
    return frozen;
  }

  public void setFrozen(Boolean frozen) {
    this.frozen = frozen;
  }

  @Override
  public String toString() {
    return "DataTypeInfo{" + "name='" + name + "'," +"subTypes='" + subTypes + "'," +"frozen='" + frozen + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DataTypeInfo that = (DataTypeInfo) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(subTypes, that.subTypes) &&
                            java.util.Objects.equals(frozen, that.frozen);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, subTypes, frozen);
  }

  public static io.stargate.graphql.types.DataTypeInfo.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private List<DataType> subTypes;

    private Boolean frozen;

    public DataTypeInfo build() {
                  io.stargate.graphql.types.DataTypeInfo result = new io.stargate.graphql.types.DataTypeInfo();
                      result.name = this.name;
          result.subTypes = this.subTypes;
          result.frozen = this.frozen;
                      return result;
    }

    public io.stargate.graphql.types.DataTypeInfo.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.DataTypeInfo.Builder subTypes(List<DataType> subTypes) {
      this.subTypes = subTypes;
      return this;
    }

    public io.stargate.graphql.types.DataTypeInfo.Builder frozen(Boolean frozen) {
      this.frozen = frozen;
      return this;
    }
  }
}
