package io.stargate.graphql.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;

public class DataTypeInfoInput {
  private List<DataTypeInput> subTypes;

  private String name;

  private Boolean frozen;

  public DataTypeInfoInput() {
  }

  public List<DataTypeInput> getSubTypes() {
    return subTypes;
  }

  public void setSubTypes(List<DataTypeInput> subTypes) {
    this.subTypes = subTypes;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Boolean getFrozen() {
    return frozen;
  }

  public void setFrozen(Boolean frozen) {
    this.frozen = frozen;
  }

  @Override
  public String toString() {
    return "DataTypeInfoInput{" + "subTypes='" + subTypes + "'," +"name='" + name + "'," +"frozen='" + frozen + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DataTypeInfoInput that = (DataTypeInfoInput) o;
        return java.util.Objects.equals(subTypes, that.subTypes) &&
                            java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(frozen, that.frozen);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(subTypes, name, frozen);
  }

  public static io.stargate.graphql.types.DataTypeInfoInput.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<DataTypeInput> subTypes;

    private String name;

    private Boolean frozen;

    public DataTypeInfoInput build() {
                  io.stargate.graphql.types.DataTypeInfoInput result = new io.stargate.graphql.types.DataTypeInfoInput();
                      result.subTypes = this.subTypes;
          result.name = this.name;
          result.frozen = this.frozen;
                      return result;
    }

    public io.stargate.graphql.types.DataTypeInfoInput.Builder subTypes(
        List<DataTypeInput> subTypes) {
      this.subTypes = subTypes;
      return this;
    }

    public io.stargate.graphql.types.DataTypeInfoInput.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.DataTypeInfoInput.Builder frozen(Boolean frozen) {
      this.frozen = frozen;
      return this;
    }
  }
}
