package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public class Field {
  private String name;

  private DataType type;

  public Field() {
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataType getType() {
    return type;
  }

  public void setType(DataType type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "Field{" + "name='" + name + "'," +"type='" + type + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Field that = (Field) o;
        return java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(name, type);
  }

  public static io.stargate.graphql.types.Field.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private DataType type;

    public Field build() {
                  io.stargate.graphql.types.Field result = new io.stargate.graphql.types.Field();
                      result.name = this.name;
          result.type = this.type;
                      return result;
    }

    public io.stargate.graphql.types.Field.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.Field.Builder type(DataType type) {
      this.type = type;
      return this;
    }
  }
}
