package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;

public class Keyspace {
  private List<DataCenter> dcs;

  private String name;

  private Table table;

  private List<Table> tables;

  private Type type;

  private List<Type> types;

  public Keyspace() {
  }

  public List<DataCenter> getDcs() {
    return dcs;
  }

  public void setDcs(List<DataCenter> dcs) {
    this.dcs = dcs;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Table getTable() {
    return table;
  }

  public void setTable(Table table) {
    this.table = table;
  }

  public List<Table> getTables() {
    return tables;
  }

  public void setTables(List<Table> tables) {
    this.tables = tables;
  }

  public Type getType() {
    return type;
  }

  public void setType(Type type) {
    this.type = type;
  }

  public List<Type> getTypes() {
    return types;
  }

  public void setTypes(List<Type> types) {
    this.types = types;
  }

  @Override
  public String toString() {
    return "Keyspace{" + "dcs='" + dcs + "'," +"name='" + name + "'," +"table='" + table + "'," +"tables='" + tables + "'," +"type='" + type + "'," +"types='" + types + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Keyspace that = (Keyspace) o;
        return java.util.Objects.equals(dcs, that.dcs) &&
                            java.util.Objects.equals(name, that.name) &&
                            java.util.Objects.equals(table, that.table) &&
                            java.util.Objects.equals(tables, that.tables) &&
                            java.util.Objects.equals(type, that.type) &&
                            java.util.Objects.equals(types, that.types);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(dcs, name, table, tables, type, types);
  }

  public static io.stargate.graphql.types.Keyspace.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<DataCenter> dcs;

    private String name;

    private Table table;

    private List<Table> tables;

    private Type type;

    private List<Type> types;

    public Keyspace build() {
                  io.stargate.graphql.types.Keyspace result = new io.stargate.graphql.types.Keyspace();
                      result.dcs = this.dcs;
          result.name = this.name;
          result.table = this.table;
          result.tables = this.tables;
          result.type = this.type;
          result.types = this.types;
                      return result;
    }

    public io.stargate.graphql.types.Keyspace.Builder dcs(List<DataCenter> dcs) {
      this.dcs = dcs;
      return this;
    }

    public io.stargate.graphql.types.Keyspace.Builder name(String name) {
      this.name = name;
      return this;
    }

    public io.stargate.graphql.types.Keyspace.Builder table(Table table) {
      this.table = table;
      return this;
    }

    public io.stargate.graphql.types.Keyspace.Builder tables(List<Table> tables) {
      this.tables = tables;
      return this;
    }

    public io.stargate.graphql.types.Keyspace.Builder type(Type type) {
      this.type = type;
      return this;
    }

    public io.stargate.graphql.types.Keyspace.Builder types(List<Type> types) {
      this.types = types;
      return this;
    }
  }
}
