package io.stargate.graphql.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;

public class Type {
  private List<Field> fields;

  private String name;

  public Type() {
  }

  public List<Field> getFields() {
    return fields;
  }

  public void setFields(List<Field> fields) {
    this.fields = fields;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "Type{" + "fields='" + fields + "'," +"name='" + name + "'" +"}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Type that = (Type) o;
        return java.util.Objects.equals(fields, that.fields) &&
                            java.util.Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(fields, name);
  }

  public static io.stargate.graphql.types.Type.Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Field> fields;

    private String name;

    public Type build() {
                  io.stargate.graphql.types.Type result = new io.stargate.graphql.types.Type();
                      result.fields = this.fields;
          result.name = this.name;
                      return result;
    }

    public io.stargate.graphql.types.Type.Builder fields(List<Field> fields) {
      this.fields = fields;
      return this;
    }

    public io.stargate.graphql.types.Type.Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
