/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.gql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.graphql.dgs.client.codegen.BaseProjectionNode;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import com.netflix.graphql.dgs.client.codegen.GraphQLQueryRequest;
import io.stargate.graphql.client.KeyspaceGraphQLQuery;
import io.stargate.graphql.client.KeyspaceProjectionRoot;
import io.stargate.graphql.client.KeyspacesGraphQLQuery;
import io.stargate.graphql.client.KeyspacesProjectionRoot;
import io.stargate.graphql.types.Keyspace;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.gql.domain.Keyspaces;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class GraphQLKeyspaceDDLClient {
    public static final String PATH_CQL_FIRST_DDL = "/graphql-schema";
    private final LoadBalancedHttpClient stargateHttpClient;
    public Function<ServiceHttp, String> cqlSchemaResource = node -> node.getEndpoint() + PATH_CQL_FIRST_DDL;

    public GraphQLKeyspaceDDLClient(LoadBalancedHttpClient stargateClient) {
        this.stargateHttpClient = stargateClient;
    }

    public String execute(String input) {
        ApiResponseHttp res = this.stargateHttpClient.POST_GRAPHQL(this.cqlSchemaResource, input);
        return res.getBody();
    }

    public Stream<Keyspace> keyspaces() {
        return this.keyspaces(new KeyspacesProjectionRoot().name());
    }

    public Stream<Keyspace> keyspaces(KeyspacesProjectionRoot projection) {
        String graphQLRequest = new GraphQLQueryRequest((GraphQLQuery)new KeyspacesGraphQLQuery.Builder().build(), (BaseProjectionNode)projection).serialize();
        ApiResponseHttp res = this.stargateHttpClient.POST_GRAPHQL(this.cqlSchemaResource, graphQLRequest);
        return ((Keyspaces)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), (TypeReference)new TypeReference<ApiResponse<Keyspaces>>(){})).getData()).getKeyspaces().stream();
    }

    public Optional<Keyspace> keyspace(String keyspaceName, KeyspaceProjectionRoot projection) {
        String graphQLRequest = new GraphQLQueryRequest((GraphQLQuery)new KeyspaceGraphQLQuery.Builder().name(keyspaceName).build(), (BaseProjectionNode)projection).serialize();
        ApiResponseHttp res = this.stargateHttpClient.POST_GRAPHQL(this.cqlSchemaResource, graphQLRequest);
        return Optional.ofNullable((Keyspace)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), (TypeReference)new TypeReference<ApiResponse<Keyspace>>(){})).getData());
    }

    public String createKeyspaceSimple(String keyspaceName, int replicas) {
        String sb = "mutation sdkCreateKeyspace" + keyspaceName + "{\n  createKeyspace(name:\"" + keyspaceName + "\", replicas: " + replicas + ")\n}";
        return this.execute(sb);
    }
}

