/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.gql;

import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.gql.GraphQLKeyspaceDDLClient;
import io.stargate.sdk.gql.GraphQLKeyspaceDMLClient;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StargateGraphQLApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(StargateGraphQLApiClient.class);
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080";
    private static final String DEFAULT_SERVICE_ID = "sgv2-graphql";
    private static final String DEFAULT_DATACENTER = "dc1";
    private static final String PATH_HEALTH_CHECK = "/stargate/health";
    protected final LoadBalancedHttpClient stargateHttpClient;

    public StargateGraphQLApiClient() {
        this(DEFAULT_ENDPOINT);
    }

    public StargateGraphQLApiClient(String endpoint) {
        Assert.hasLength((String)endpoint, (String)"stargate endpoint");
        ServiceHttp rest = new ServiceHttp(DEFAULT_SERVICE_ID, endpoint, endpoint + PATH_HEALTH_CHECK);
        TokenProviderHttpAuth tokenProvider = new TokenProviderHttpAuth();
        ServiceDatacenter sDc = new ServiceDatacenter(DEFAULT_DATACENTER, (TokenProvider)tokenProvider, Collections.singletonList(rest));
        ServiceDeployment deploy = new ServiceDeployment().addDatacenter(sDc);
        this.stargateHttpClient = new LoadBalancedHttpClient(deploy);
    }

    public StargateGraphQLApiClient(ServiceDeployment<ServiceHttp> serviceDeployment) {
        Assert.notNull(serviceDeployment, (String)"service deployment topology");
        this.stargateHttpClient = new LoadBalancedHttpClient(serviceDeployment);
        LOGGER.info("+ API GraphQL  :[" + AnsiUtils.green((String)"{}") + "]", (Object)"ENABLED");
    }

    public GraphQLKeyspaceDDLClient keyspaceDDL() {
        return new GraphQLKeyspaceDDLClient(this.stargateHttpClient);
    }

    public GraphQLKeyspaceDMLClient keyspaceDML(String keyspace) {
        return new GraphQLKeyspaceDMLClient(this.stargateHttpClient, keyspace);
    }

    public GraphQLKeyspaceDDLClient graphQLFirst() {
        return new GraphQLKeyspaceDDLClient(this.stargateHttpClient);
    }
}

