/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc;

import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.stargate.grpc.StargateBearerToken;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.StargateGrpc;
import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.audit.ServiceCallEvent;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.grpc.audit.ServiceGrpcCallEvent;
import io.stargate.sdk.grpc.domain.BatchGrpc;
import io.stargate.sdk.grpc.domain.QueryGrpc;
import io.stargate.sdk.grpc.domain.ResultSetGrpc;
import io.stargate.sdk.grpc.utils.FuturesUtils;
import io.stargate.sdk.grpc.utils.StreamObserverToReactivePublisher;
import io.stargate.sdk.utils.CompletableFutures;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class GrpcClient
implements ApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClient.class);
    private static GrpcClient _instance = null;
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final Duration DEFAULT_RETRY_DELAY = Duration.ofMillis(100L);
    protected RetryConfig retryConfig = new RetryConfigBuilder().retryOnAnyException().withDelayBetweenTries(DEFAULT_RETRY_DELAY).withExponentialBackoff().withMaxNumberOfTries(3).build();
    protected static Map<String, ServiceCallObserver> apiInvocationsObserversMap = new ConcurrentHashMap<String, ServiceCallObserver>();

    private GrpcClient() {
    }

    public static synchronized GrpcClient getInstance() {
        if (_instance == null) {
            _instance = new GrpcClient();
        }
        return _instance;
    }

    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public ResultSetGrpc execute(ServiceGrpc sGrpc, QueryGrpc query, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, query);
        StargateGrpc.StargateBlockingStub syncStub = (StargateGrpc.StargateBlockingStub)((StargateGrpc.StargateBlockingStub)StargateGrpc.newBlockingStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        try {
            Status<QueryOuterClass.Response> status = this.executeWithRetries(syncStub, this.mapGrpcQuery(query));
            event.setTotalTries(status.getTotalTries());
            event.setLastException(status.getLastExceptionThatCausedRetry());
            event.setResponseElapsedTime(status.getTotalElapsedDuration().toMillis());
            event.setResponseTimestamp(status.getEndTime());
            ResultSetGrpc resultSetGrpc = new ResultSetGrpc(((QueryOuterClass.Response)status.getResult()).getResultSet());
            return resultSetGrpc;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    public ResultSetGrpc executeBatch(ServiceGrpc sGrpc, BatchGrpc batch, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, batch);
        StargateGrpc.StargateBlockingStub syncStub = (StargateGrpc.StargateBlockingStub)((StargateGrpc.StargateBlockingStub)StargateGrpc.newBlockingStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        try {
            long top = -System.currentTimeMillis();
            QueryOuterClass.Response response = syncStub.executeBatch(this.mapGrpcBatch(batch));
            event.setResponseElapsedTime(System.currentTimeMillis() - top);
            event.setResponseTimestamp(event.getResponseElapsedTime());
            ResultSetGrpc resultSetGrpc = new ResultSetGrpc(response.getResultSet());
            return resultSetGrpc;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(ServiceGrpc sGrpc, QueryGrpc query, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, query);
        StargateGrpc.StargateFutureStub futureStub = (StargateGrpc.StargateFutureStub)((StargateGrpc.StargateFutureStub)StargateGrpc.newFutureStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        long startTime = System.currentTimeMillis();
        try {
            CompletionStage completionStage = FuturesUtils.asCompletableFuture(futureStub.executeQuery(this.mapGrpcQuery(query))).thenApply(res -> {
                event.setResponseTime(System.currentTimeMillis() - startTime);
                return new ResultSetGrpc(res.getResultSet());
            });
            return completionStage;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    public CompletableFuture<ResultSetGrpc> executeBatchAsync(ServiceGrpc sGrpc, BatchGrpc batch, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, batch);
        StargateGrpc.StargateFutureStub futureStub = (StargateGrpc.StargateFutureStub)((StargateGrpc.StargateFutureStub)StargateGrpc.newFutureStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        long startTime = System.currentTimeMillis();
        try {
            CompletionStage completionStage = FuturesUtils.asCompletableFuture(futureStub.executeBatch(this.mapGrpcBatch(batch))).thenApply(res -> {
                event.setResponseTime(System.currentTimeMillis() - startTime);
                return new ResultSetGrpc(res.getResultSet());
            });
            return completionStage;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    public Mono<ResultSetGrpc> executeReactive(ServiceGrpc sGrpc, QueryGrpc query, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, query);
        StargateGrpc.StargateStub reactiveStub = (StargateGrpc.StargateStub)((StargateGrpc.StargateStub)StargateGrpc.newStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        long startTime = System.currentTimeMillis();
        try {
            StreamObserverToReactivePublisher streamObserverPublisher = new StreamObserverToReactivePublisher();
            Mono mono = Mono.from(streamObserverPublisher);
            reactiveStub.executeQuery(this.mapGrpcQuery(query), streamObserverPublisher);
            Mono mono2 = mono.map(res -> new ResultSetGrpc(res.getResultSet()));
            return mono2;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    public Mono<ResultSetGrpc> executeBatchReactive(ServiceGrpc sGrpc, BatchGrpc batch, String token) {
        ServiceGrpcCallEvent event = new ServiceGrpcCallEvent(sGrpc, batch);
        StargateGrpc.StargateStub reactiveStub = (StargateGrpc.StargateStub)((StargateGrpc.StargateStub)StargateGrpc.newStub((Channel)sGrpc.getChannel()).withCallCredentials((CallCredentials)new StargateBearerToken(token))).withDeadlineAfter(5L, TimeUnit.SECONDS);
        long startTime = System.currentTimeMillis();
        try {
            StreamObserverToReactivePublisher streamObserverPublisher = new StreamObserverToReactivePublisher();
            Mono mono = Mono.from(streamObserverPublisher);
            reactiveStub.executeBatch(this.mapGrpcBatch(batch), streamObserverPublisher);
            Mono mono2 = mono.map(res -> new ResultSetGrpc(res.getResultSet()));
            return mono2;
        }
        catch (RuntimeException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall((ServiceCallEvent)event)));
        }
    }

    private QueryOuterClass.Batch mapGrpcBatch(BatchGrpc batchGrpc) {
        QueryOuterClass.Batch.Builder batchBuilder = QueryOuterClass.Batch.newBuilder();
        QueryOuterClass.BatchParameters.Builder bbb = QueryOuterClass.BatchParameters.newBuilder();
        QueryOuterClass.BatchQuery.newBuilder().setCql("req1").setValues(QueryOuterClass.Values.newBuilder().build());
        return null;
    }

    private QueryOuterClass.Query mapGrpcQuery(QueryGrpc queryGrpc) {
        QueryOuterClass.Values.Builder valuesBuilder;
        QueryOuterClass.Query.Builder queryBuilder = QueryOuterClass.Query.newBuilder();
        queryBuilder.setCql(queryGrpc.getCqlStatement().getCql());
        if (!queryGrpc.getCqlStatement().getPositionalValues().isEmpty()) {
            valuesBuilder = QueryOuterClass.Values.newBuilder();
            queryGrpc.getCqlStatement().getPositionalValues().forEach(p -> valuesBuilder.addValues(this.mapGrpcValue(p)));
            queryBuilder.setValues(valuesBuilder);
        }
        if (!queryGrpc.getCqlStatement().getNamedValues().isEmpty()) {
            valuesBuilder = QueryOuterClass.Values.newBuilder();
            queryGrpc.getCqlStatement().getNamedValues().forEach((key, value) -> {
                valuesBuilder.addValueNames(key);
                valuesBuilder.addValues(this.mapGrpcValue(value));
            });
            queryBuilder.setValues(valuesBuilder);
        }
        QueryOuterClass.QueryParameters.Builder queryParamsBuilder = QueryOuterClass.QueryParameters.newBuilder();
        if (null != queryGrpc.getConsistencyLevel()) {
            queryParamsBuilder.setConsistency(QueryOuterClass.ConsistencyValue.newBuilder().setValue(queryGrpc.getConsistencyLevel()).build());
        }
        if (queryGrpc.getPageSize() > 0) {
            queryParamsBuilder.setPageSize(Int32Value.newBuilder().setValue(queryGrpc.getPageSize()).build());
        }
        if (queryGrpc.getPagingState() != null) {
            queryParamsBuilder.setPagingState(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)queryGrpc.getPagingState())).build());
        }
        if (queryGrpc.getKeyspace() != null) {
            queryParamsBuilder.setKeyspace(StringValue.newBuilder().setValue(queryGrpc.getKeyspace()));
        }
        if (queryGrpc.getTimestamp() > 0L) {
            queryParamsBuilder.setTimestamp(Int64Value.of((long)queryGrpc.getTimestamp()));
        }
        if (queryGrpc.isTracing()) {
            queryParamsBuilder.setTracing(true);
        }
        queryBuilder.setParameters(queryParamsBuilder);
        return queryBuilder.build();
    }

    private QueryOuterClass.Value mapGrpcValue(Object o) {
        QueryOuterClass.Value.Builder vb = QueryOuterClass.Value.newBuilder();
        if (o instanceof String) {
            vb.setString((String)o);
        } else if (o instanceof Boolean) {
            vb.setBoolean(((Boolean)o).booleanValue());
        } else if (o instanceof byte[]) {
            vb.setBytes(ByteString.copyFrom((byte[])((byte[])o)));
        } else if (o instanceof BigDecimal) {
            // empty if block
        }
        return vb.build();
    }

    private Status<QueryOuterClass.Response> executeWithRetries(StargateGrpc.StargateBlockingStub stub, QueryOuterClass.Query grpcQuery) {
        return new CallExecutorBuilder().config(this.retryConfig).onSuccessListener(s -> CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onSuccess(s)))).onCompletionListener(s -> CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCompletion(s)))).onFailureListener(s -> {
            LOGGER.error("Calls failed after {} retries", (Object)s.getTotalTries());
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onFailure(s)));
        }).afterFailedTryListener(s -> {
            LOGGER.error("Failure on attempt {}/{} ", (Object)s.getTotalTries(), (Object)this.retryConfig.getMaxNumberOfTries());
            LOGGER.error("Failed request {} on {}", (Object)grpcQuery.getCql(), (Object)stub.getChannel().toString());
            LOGGER.error("+ Exception was ", (Throwable)s.getLastExceptionThatCausedRetry());
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onFailedTry(s)));
        }).build().execute(() -> stub.executeQuery(grpcQuery));
    }

    public static void registerListener(String name, ServiceCallObserver listener) {
        apiInvocationsObserversMap.put(name, listener);
    }

    private void notifyAsync(Consumer<ServiceCallObserver> lambda) {
        CompletableFutures.allDone(apiInvocationsObserversMap.values().stream().map(l -> CompletableFuture.runAsync(() -> lambda.accept((ServiceCallObserver)l))).collect(Collectors.toList()));
    }
}

