/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc;

import io.stargate.sdk.ManagedServiceDeployment;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.grpc.GrpcClient;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.grpc.domain.BatchGrpc;
import io.stargate.sdk.grpc.domain.QueryGrpc;
import io.stargate.sdk.grpc.domain.ResultSetGrpc;
import io.stargate.sdk.loadbalancer.LoadBalancedResource;
import io.stargate.sdk.loadbalancer.NoneResourceAvailableException;
import io.stargate.sdk.loadbalancer.UnavailableResourceException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class GrpcClientLoadBalanced
implements ApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClientLoadBalanced.class);
    private final ManagedServiceDeployment<ServiceGrpc> deployment;

    public GrpcClientLoadBalanced(ServiceDeployment<ServiceGrpc> conf) {
        this.deployment = new ManagedServiceDeployment(conf);
    }

    public ResultSetGrpc execute(QueryGrpc query) {
        LoadBalancedResource lb = null;
        while (true) {
            try {
                ServiceGrpc serviceGrpc;
                while ((serviceGrpc = (ServiceGrpc)((Object)(lb = this.deployment.lookupStargateNode()).getResource())) == null) {
                }
                return GrpcClient.getInstance().execute(serviceGrpc, query, this.deployment.lookupToken());
            }
            catch (UnavailableResourceException rex) {
                LOGGER.warn("A stargate node is down [], falling back to another node...");
                try {
                    this.deployment.failOverStargateNode(lb, (Throwable)rex);
                }
                catch (NoneResourceAvailableException nex) {
                    LOGGER.warn("No node available is localDc [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                    this.deployment.failOverDatacenter();
                }
                continue;
            }
            catch (NoneResourceAvailableException nex) {
                LOGGER.warn("No node available is DataCenter [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                this.deployment.failOverDatacenter();
                continue;
            }
            break;
        }
    }

    public ResultSetGrpc executeBatch(BatchGrpc batch) {
        LoadBalancedResource lb = null;
        while (true) {
            try {
                ServiceGrpc serviceGrpc;
                while ((serviceGrpc = (ServiceGrpc)((Object)(lb = this.deployment.lookupStargateNode()).getResource())) == null) {
                }
                return GrpcClient.getInstance().executeBatch(serviceGrpc, batch, this.deployment.lookupToken());
            }
            catch (UnavailableResourceException rex) {
                LOGGER.warn("A stargate node is down [], falling back to another node...");
                try {
                    this.deployment.failOverStargateNode(lb, (Throwable)rex);
                }
                catch (NoneResourceAvailableException nex) {
                    LOGGER.warn("No node available is localDc [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                    this.deployment.failOverDatacenter();
                }
                continue;
            }
            catch (NoneResourceAvailableException nex) {
                LOGGER.warn("No node available is DataCenter [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                this.deployment.failOverDatacenter();
                continue;
            }
            break;
        }
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(QueryGrpc query) {
        LoadBalancedResource lb = null;
        while (true) {
            try {
                lb = this.deployment.lookupStargateNode();
                ServiceGrpc sGrpc = (ServiceGrpc)((Object)lb.getResource());
                return GrpcClient.getInstance().executeAsync(sGrpc, query, this.deployment.lookupToken());
            }
            catch (UnavailableResourceException rex) {
                LOGGER.warn("A stargate node is down [], falling back to another node...");
                try {
                    this.deployment.failOverStargateNode(lb, (Throwable)rex);
                }
                catch (NoneResourceAvailableException nex) {
                    LOGGER.warn("No node available is localDc [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                    this.deployment.failOverDatacenter();
                }
                continue;
            }
            catch (NoneResourceAvailableException nex) {
                LOGGER.warn("No node available is DataCenter [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                this.deployment.failOverDatacenter();
                continue;
            }
            break;
        }
    }

    public Mono<ResultSetGrpc> executeReactive(QueryGrpc query) {
        LoadBalancedResource lb = null;
        while (true) {
            try {
                lb = this.deployment.lookupStargateNode();
                return GrpcClient.getInstance().executeReactive((ServiceGrpc)((Object)lb.getResource()), query, this.deployment.lookupToken());
            }
            catch (UnavailableResourceException rex) {
                LOGGER.warn("A stargate node is down [], falling back to another node...");
                try {
                    this.deployment.failOverStargateNode(lb, (Throwable)rex);
                }
                catch (NoneResourceAvailableException nex) {
                    LOGGER.warn("No node available is localDc [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                    this.deployment.failOverDatacenter();
                }
                continue;
            }
            catch (NoneResourceAvailableException nex) {
                LOGGER.warn("No node available is DataCenter [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                this.deployment.failOverDatacenter();
                continue;
            }
            break;
        }
    }
}

