/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.stargate.sdk.Service;
import io.stargate.sdk.api.ApiConstants;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class ServiceGrpc
extends Service {
    protected boolean securedTransport;
    protected int maxRetries = 3;
    protected long keepAliveTimeout = 100000L;
    protected TimeUnit keepAliveTimeoutUnit = TimeUnit.MILLISECONDS;
    private ManagedChannel channel;

    public ServiceGrpc(String id, String endpoint, String healthCheckEndpoint) {
        this(id, endpoint, healthCheckEndpoint, false);
    }

    public ServiceGrpc(String id, String endpoint, String healthCheckEndpoint, boolean securedTransport) {
        super(id, endpoint, healthCheckEndpoint);
        this.securedTransport = securedTransport;
        this.initialize();
    }

    private void initialize() {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint).enableRetry().maxRetryAttempts(this.maxRetries).keepAliveTimeout(this.keepAliveTimeout, this.keepAliveTimeoutUnit).userAgent(ApiConstants.REQUEST_WITH);
        if (this.securedTransport) {
            channelBuilder.useTransportSecurity();
        } else {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
    }

    public boolean isAlive() {
        try {
            return 200 == HttpClients.createDefault().execute((ClassicHttpRequest)new HttpGet(this.healthCheckEndpoint)).getCode();
        }
        catch (Exception re) {
            return false;
        }
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setKeepAliveTimeoutUnit(TimeUnit keepAliveTimeoutUnit) {
        this.keepAliveTimeoutUnit = keepAliveTimeoutUnit;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }
}

