/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc;

import com.evanlennick.retry4j.config.RetryConfig;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.grpc.GrpcClient;
import io.stargate.sdk.grpc.GrpcClientLoadBalanced;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.grpc.domain.BatchGrpc;
import io.stargate.sdk.grpc.domain.QueryGrpc;
import io.stargate.sdk.grpc.domain.ResultSetGrpc;
import io.stargate.sdk.grpc.domain.RowGrpcMapper;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StargateGrpcApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(StargateGrpcApiClient.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8090;
    private static final String PATH_HEALTH_CHECK = "/stargate/health";
    private static final int DEFAULT_HEALTH_CHECK_PORT = 8084;
    private static final String DEFAULT_SERVICE_ID = "sgv2-grpc";
    private static final String DEFAULT_DATACENTER = "dc1";
    private final GrpcClientLoadBalanced lbGrpcClient;

    public StargateGrpcApiClient() {
        this("localhost:8090", "localhost:8084/stargate/health");
    }

    public StargateGrpcApiClient(ServiceDeployment<ServiceGrpc> serviceDeployment) {
        Assert.notNull(serviceDeployment, (String)"stargate client reference. ");
        this.lbGrpcClient = new GrpcClientLoadBalanced(serviceDeployment);
        LOGGER.info("+ API Grpc     :[" + AnsiUtils.green((String)"{}") + "]", (Object)"ENABLED");
    }

    public StargateGrpcApiClient(String endpoint, String healthCheckUrl) {
        Assert.hasLength((String)endpoint, (String)"stargate grpc endpoint");
        Assert.hasLength((String)healthCheckUrl, (String)"stargate grpc health check");
        ServiceGrpc rest = new ServiceGrpc(DEFAULT_SERVICE_ID, endpoint, healthCheckUrl);
        TokenProviderHttpAuth tokenProvider = new TokenProviderHttpAuth();
        ServiceDatacenter sDc = new ServiceDatacenter(DEFAULT_DATACENTER, (TokenProvider)tokenProvider, Collections.singletonList(rest));
        ServiceDeployment deploy = new ServiceDeployment().addDatacenter(sDc);
        this.lbGrpcClient = new GrpcClientLoadBalanced((ServiceDeployment<ServiceGrpc>)deploy);
    }

    public ResultSetGrpc execute(QueryGrpc query) {
        return this.lbGrpcClient.execute(query);
    }

    public <T> Page<T> execute(QueryGrpc query, RowGrpcMapper<T> mapper) {
        return this.mapFromRowResultPage(this.execute(query), mapper);
    }

    public ResultSetGrpc execute(String cql) {
        return this.execute(new QueryGrpc(cql));
    }

    public <T> Page<T> execute(String cql, RowGrpcMapper<T> mapper) {
        return this.mapFromRowResultPage(this.execute(new QueryGrpc(cql)), mapper);
    }

    private <T> Page<T> mapFromRowResultPage(ResultSetGrpc rrp, RowGrpcMapper<T> mapper) {
        return new Page(rrp.getPageSize(), (String)rrp.getPageState().orElse(null), rrp.getResults().stream().map(mapper::map).collect(Collectors.toList()));
    }

    public ResultSetGrpc execute(String cql, Object ... params) {
        return this.execute(new QueryGrpc(cql, params));
    }

    public ResultSetGrpc execute(String cql, Map<String, Object> params) {
        return this.execute(new QueryGrpc(cql, params));
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(QueryGrpc query) {
        return this.lbGrpcClient.executeAsync(query);
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(String cql) {
        return this.executeAsync(new QueryGrpc(cql));
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(String cql, Object ... params) {
        return this.executeAsync(new QueryGrpc(cql, params));
    }

    public CompletableFuture<ResultSetGrpc> executeAsync(String cql, Map<String, Object> params) {
        return this.executeAsync(new QueryGrpc(cql, params));
    }

    public Mono<ResultSetGrpc> executeReactive(QueryGrpc query) {
        return this.lbGrpcClient.executeReactive(query);
    }

    public Mono<ResultSetGrpc> executeReactive(String cql) {
        return this.executeReactive(new QueryGrpc(cql));
    }

    public Mono<ResultSetGrpc> executeReactive(String cql, Object ... params) {
        return this.executeReactive(new QueryGrpc(cql, params));
    }

    public Mono<ResultSetGrpc> executeReactive(String cql, Map<String, Object> params) {
        return this.executeReactive(new QueryGrpc(cql, params));
    }

    public ResultSetGrpc executeBatch(BatchGrpc grpcBatch) {
        return this.lbGrpcClient.executeBatch(grpcBatch);
    }

    public <T> Page<T> execute(QueryGrpc query, Class<T> clazz) {
        throw new UnsupportedOperationException("Object Mapping is not yet available");
    }

    public static void registerListener(String name, ServiceCallObserver listener) {
        GrpcClient.registerListener(name, listener);
    }

    public void setupRetryConfig(RetryConfig retryConfig) {
        GrpcClient.getInstance().setRetryConfig(retryConfig);
    }
}

