/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc.domain;

import io.stargate.proto.QueryOuterClass;
import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.grpc.domain.RowGrpc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultSetGrpc
extends Page<RowGrpc> {
    private final QueryOuterClass.ResultSet resultSet;
    private final List<String> columnsNames = new ArrayList<String>();
    private final Map<String, Integer> columnsIndexes = new HashMap<String, Integer>();

    public ResultSetGrpc(QueryOuterClass.ResultSet rs) {
        super(rs.getRowsCount(), rs.hasPagingState() ? rs.getPagingState().getValue().toStringUtf8() : null);
        this.resultSet = rs;
        for (int i = 0; i < rs.getColumnsCount(); ++i) {
            QueryOuterClass.ColumnSpec cs = rs.getColumns(i);
            this.columnsIndexes.put(cs.getName(), i);
            this.columnsNames.add(cs.getName());
        }
        this.setResult(rs.getRowsList().stream().map(r -> new RowGrpc(this, (QueryOuterClass.Row)r)).collect(Collectors.toList()));
    }

    public RowGrpc one() {
        if (1 != this.resultSet.getRowsCount()) {
            throw new IllegalArgumentException("Result set contains more than 1 row");
        }
        return (RowGrpc)this.getResults().get(0);
    }

    int getColumnIndex(String name) {
        if (!this.columnsIndexes.containsKey(name)) {
            throw new IllegalArgumentException("Column '" + name + "' is unknown, use " + this.columnsNames);
        }
        return this.columnsIndexes.get(name);
    }
}

