/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.grpc.utils;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class FuturesUtils {
    private FuturesUtils() {
    }

    public static final <T> CompletableFuture<T> asCompletableFuture(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable t) {
                completable.completeExceptionally(t);
            }
        }, (Executor)Executors.newFixedThreadPool(5));
        return completable;
    }
}

