/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.KeyspaceClient;
import io.stargate.sdk.rest.domain.Keyspace;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StargateRestApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(StargateRestApiClient.class);
    public static final String PATH_KEYSPACES = "/keyspaces";
    public static final String PATH_SCHEMA = "/schemas";
    public static final String PATH_V2 = "/v2";
    public static final String DEFAULT_ENDPOINT = "http://localhost:8082";
    public static final String DEFAULT_SERVICE_ID = "sgv2-rest";
    public static final String DEFAULT_DATACENTER = "dc1";
    public static final String PATH_HEALTH_CHECK = "/stargate/health";
    protected final LoadBalancedHttpClient stargateHttpClient;
    public Function<ServiceHttp, String> keyspacesResource = node -> node.getEndpoint() + PATH_V2 + PATH_KEYSPACES;
    public Function<ServiceHttp, String> keyspacesSchemaResource = node -> node.getEndpoint() + PATH_V2 + PATH_SCHEMA + PATH_KEYSPACES;

    public StargateRestApiClient() {
        this(DEFAULT_ENDPOINT);
    }

    public StargateRestApiClient(String endpoint) {
        Assert.hasLength((String)endpoint, (String)"stargate endpoint");
        ServiceHttp rest = new ServiceHttp(DEFAULT_SERVICE_ID, endpoint, endpoint + PATH_HEALTH_CHECK);
        TokenProviderHttpAuth tokenProvider = new TokenProviderHttpAuth();
        ServiceDatacenter sDc = new ServiceDatacenter(DEFAULT_DATACENTER, (TokenProvider)tokenProvider, Collections.singletonList(rest));
        ServiceDeployment deploy = new ServiceDeployment().addDatacenter(sDc);
        this.stargateHttpClient = new LoadBalancedHttpClient(deploy);
    }

    public StargateRestApiClient(ServiceDeployment<ServiceHttp> serviceDeployment) {
        Assert.notNull(serviceDeployment, (String)"service deployment topology");
        this.stargateHttpClient = new LoadBalancedHttpClient(serviceDeployment);
        LOGGER.info("+ API Data     :[" + AnsiUtils.green((String)"{}") + "]", (Object)"ENABLED");
    }

    public Stream<Keyspace> keyspaces() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.keyspacesSchemaResource);
        ApiResponse res2 = (ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), (TypeReference)new TypeReference<ApiResponse<List<Keyspace>>>(){});
        return ((List)res2.getData()).stream();
    }

    public Stream<String> keyspaceNames() {
        return this.keyspaces().map(Keyspace::getName);
    }

    public LoadBalancedHttpClient getStargateHttpClient() {
        return this.stargateHttpClient;
    }

    public KeyspaceClient keyspace(String keyspace) {
        return new KeyspaceClient(this, keyspace);
    }
}

