/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.core.Sort;
import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.core.domain.Row;
import io.stargate.sdk.core.domain.RowMapper;
import io.stargate.sdk.core.domain.RowResultPage;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.ColumnsClient;
import io.stargate.sdk.rest.IndexClient;
import io.stargate.sdk.rest.KeyClient;
import io.stargate.sdk.rest.KeyspaceClient;
import io.stargate.sdk.rest.domain.ColumnDefinition;
import io.stargate.sdk.rest.domain.CreateIndex;
import io.stargate.sdk.rest.domain.CreateTable;
import io.stargate.sdk.rest.domain.IndexDefinition;
import io.stargate.sdk.rest.domain.SearchTableQuery;
import io.stargate.sdk.rest.domain.TableDefinition;
import io.stargate.sdk.rest.domain.TableOptions;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableClient {
    public static final String PATH_COLUMNS = "/columns";
    public static final String PATH_INDEXES = "/indexes";
    private final LoadBalancedHttpClient stargateHttpClient;
    private KeyspaceClient keyspaceClient;
    private String tableName;
    private Map<String, ColumnsClient> columnsClient = new HashMap<String, ColumnsClient>();
    private Map<String, IndexClient> indexsClient = new HashMap<String, IndexClient>();
    private static final TypeReference<ApiResponse<List<ColumnDefinition>>> TYPE_LIST_COLUMNS = new TypeReference<ApiResponse<List<ColumnDefinition>>>(){};
    private static final TypeReference<ApiResponse<List<LinkedHashMap<String, ?>>>> TYPE_RESULTS = new TypeReference<ApiResponse<List<LinkedHashMap<String, ?>>>>(){};
    private static final TypeReference<List<IndexDefinition>> TYPE_LIST_INDEX = new TypeReference<List<IndexDefinition>>(){};
    public Function<ServiceHttp, String> tableSchemaResource = node -> this.keyspaceClient.tablesSchemaResource.apply((ServiceHttp)node) + "/" + this.tableName;
    public Function<ServiceHttp, String> tableResource = node -> this.keyspaceClient.keyspaceResource.apply((ServiceHttp)node) + "/" + this.tableName;
    public Function<ServiceHttp, String> columnsSchemaResource = node -> this.tableSchemaResource.apply((ServiceHttp)node) + PATH_COLUMNS;
    public Function<ServiceHttp, String> indexesSchemaResource = node -> this.tableSchemaResource.apply((ServiceHttp)node) + PATH_INDEXES;

    public TableClient(LoadBalancedHttpClient stargateHttpClient, KeyspaceClient keyspaceClient, String tableName) {
        this.stargateHttpClient = stargateHttpClient;
        this.keyspaceClient = keyspaceClient;
        this.tableName = tableName;
        Assert.notNull((Object)keyspaceClient, (String)"keyspaceClient");
        Assert.hasLength((String)tableName, (String)"tableName");
    }

    public Optional<TableDefinition> find() {
        return this.keyspaceClient.tables().filter(t -> this.tableName.equalsIgnoreCase(t.getName())).findFirst();
    }

    public boolean exist() {
        return this.keyspaceClient.tableNames().anyMatch(this.tableName::equals);
    }

    public void create(CreateTable tcr) {
        tcr.setName(this.tableName);
        Assert.notNull((Object)tcr, (String)"CreateTable");
        this.stargateHttpClient.POST(this.keyspaceClient.tablesSchemaResource, JsonUtils.marshall((Object)tcr));
    }

    public void updateOptions(TableOptions to) {
        Assert.notNull((Object)to, (String)"TableCreationRequest");
        CreateTable ct = CreateTable.builder().build();
        ct.setPrimaryKey(null);
        ct.setColumnDefinitions(null);
        ct.setName(this.tableName);
        ct.setTableOptions(to);
        this.stargateHttpClient.PUT(this.tableSchemaResource, JsonUtils.marshall((Object)ct));
    }

    public void delete() {
        this.stargateHttpClient.DELETE(this.tableSchemaResource);
    }

    public void upsert(Map<String, Object> record) {
        Assert.notNull(record, (String)"New Record");
        Assert.isTrue((Boolean)(!record.isEmpty() ? 1 : 0), (String)"New record should not be empty");
        this.stargateHttpClient.POST(this.tableResource, JsonUtils.marshall(record));
    }

    public RowResultPage search(SearchTableQuery query) {
        Assert.notNull((Object)query, (String)"query");
        ApiResponseHttp res = this.stargateHttpClient.GET(this.tableResource, this.buildSearchUrlSuffix(query));
        ApiResponse result = (ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), TYPE_RESULTS);
        return new RowResultPage(query.getPageSize(), result.getPageState(), ((List)result.getData()).stream().map(map -> {
            Row r = new Row();
            for (Map.Entry val : map.entrySet()) {
                r.put((Object)((String)val.getKey()), val.getValue());
            }
            return r;
        }).collect(Collectors.toList()));
    }

    public <T> Page<T> search(SearchTableQuery query, RowMapper<T> mapper) {
        RowResultPage rrp = this.search(query);
        return new Page(rrp.getPageSize(), (String)rrp.getPageState().orElse(null), rrp.getResults().stream().map(arg_0 -> mapper.map(arg_0)).collect(Collectors.toList()));
    }

    private String buildSearchUrlSuffix(SearchTableQuery query) {
        try {
            StringBuilder sbUrl = new StringBuilder();
            sbUrl.append("?page-size=" + query.getPageSize());
            if (query.getPageState().isPresent()) {
                sbUrl.append("&page-state=" + URLEncoder.encode(query.getPageState().get(), StandardCharsets.UTF_8.toString()));
            }
            if (query.getWhere().isPresent()) {
                sbUrl.append("&where=" + URLEncoder.encode(query.getWhere().get(), StandardCharsets.UTF_8.toString()));
            }
            if (null != query.getFieldsToRetrieve() && !query.getFieldsToRetrieve().isEmpty()) {
                sbUrl.append("&fields=" + URLEncoder.encode(String.join((CharSequence)",", query.getFieldsToRetrieve()), StandardCharsets.UTF_8.toString()));
            }
            if (null != query.getFieldsToSort() && !query.getFieldsToSort().isEmpty()) {
                LinkedHashMap<String, String> sortFields = new LinkedHashMap<String, String>();
                for (Sort sf : query.getFieldsToSort()) {
                    sortFields.put(sf.getFieldName(), sf.getOrder().name());
                }
                sbUrl.append("&sort=" + URLEncoder.encode(JsonUtils.mapAsJson(sortFields), StandardCharsets.UTF_8.toString()));
            }
            return sbUrl.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot enode URL", e);
        }
    }

    public Stream<ColumnDefinition> columns() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.columnsSchemaResource);
        return ((List)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), TYPE_LIST_COLUMNS)).getData()).stream().collect(Collectors.toSet()).stream();
    }

    public void createColumn(String colName, ColumnDefinition cd) {
        this.column(colName).create(cd);
    }

    public Stream<String> columnNames() {
        return this.columns().map(ColumnDefinition::getName);
    }

    public Stream<IndexDefinition> indexes() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.indexesSchemaResource);
        return ((List)JsonUtils.unmarshallType((String)res.getBody(), TYPE_LIST_INDEX)).stream().collect(Collectors.toSet()).stream();
    }

    public void createIndex(String idxName, CreateIndex ci) {
        this.index(idxName).create(ci);
    }

    public Stream<String> indexesNames() {
        return this.indexes().map(IndexDefinition::getIndex_name);
    }

    public ColumnsClient column(String columnId) {
        Assert.hasLength((String)columnId, (String)"columnName");
        if (!this.columnsClient.containsKey(columnId)) {
            this.columnsClient.put(columnId, new ColumnsClient(this.stargateHttpClient, this, columnId));
        }
        return this.columnsClient.get(columnId);
    }

    public IndexClient index(String indexName) {
        Assert.hasLength((String)indexName, (String)"indexName");
        if (!this.indexsClient.containsKey(indexName)) {
            this.indexsClient.put(indexName, new IndexClient(this.stargateHttpClient, this, indexName));
        }
        return this.indexsClient.get(indexName);
    }

    public KeyClient key(Object ... keys) {
        Assert.notNull((Object)keys, (String)"key");
        return new KeyClient(this.stargateHttpClient, this, keys);
    }

    public String getTableName() {
        return this.tableName;
    }
}

