/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.rest.KeyspaceClient;
import io.stargate.sdk.rest.domain.CreateType;
import io.stargate.sdk.rest.domain.TypeDefinition;
import io.stargate.sdk.rest.domain.UpdateType;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Optional;
import java.util.function.Function;

public class TypeClient {
    private final LoadBalancedHttpClient stargateHttpClient;
    private KeyspaceClient keyspaceClient;
    private String typeName;
    public Function<ServiceHttp, String> typeSchemaResource = node -> this.keyspaceClient.typesSchemaResource.apply((ServiceHttp)node) + "/" + this.typeName;
    public Function<ServiceHttp, String> typeResource = node -> this.keyspaceClient.typesResource.apply((ServiceHttp)node) + "/" + this.typeName;

    public TypeClient(LoadBalancedHttpClient stargateHttpClient, KeyspaceClient keyspaceClient, String typeName) {
        this.keyspaceClient = keyspaceClient;
        this.stargateHttpClient = stargateHttpClient;
        this.typeName = typeName;
        Assert.notNull((Object)keyspaceClient, (String)"keyspaceClient");
        Assert.hasLength((String)typeName, (String)"typeName");
    }

    public Optional<TypeDefinition> find() {
        return this.keyspaceClient.types().filter(t -> this.typeName.equalsIgnoreCase(t.getName())).findFirst();
    }

    public boolean exist() {
        return this.keyspaceClient.typeNames().anyMatch(this.typeName::equals);
    }

    public void create(CreateType tcr) {
        this.stargateHttpClient.POST(this.keyspaceClient.typesSchemaResource, JsonUtils.marshall((Object)tcr));
    }

    public void update(UpdateType update) {
        Assert.notNull((Object)update, (String)"updateQuery");
        update.setName(this.typeName);
        this.stargateHttpClient.PUT(this.keyspaceClient.typesSchemaResource, JsonUtils.marshall((Object)update));
    }

    public void delete() {
        this.stargateHttpClient.DELETE(this.typeSchemaResource);
    }

    public String getTypeName() {
        return this.typeName;
    }
}

