/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest.domain;

import io.stargate.sdk.core.Ordering;
import io.stargate.sdk.rest.domain.ClusteringExpression;
import io.stargate.sdk.rest.domain.ColumnDefinition;
import io.stargate.sdk.rest.domain.TableOptions;
import io.stargate.sdk.rest.domain.TablePrimaryKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateTable
implements Serializable {
    private static final long serialVersionUID = -163637535414120053L;
    private String name;
    private boolean ifNotExists = false;
    private TablePrimaryKey primaryKey = new TablePrimaryKey();
    private List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    private TableOptions tableOptions = new TableOptions();

    public CreateTable() {
    }

    private CreateTable(CreateTableBuilder builder) {
        this.ifNotExists = builder.ifNotExists;
        this.name = builder.name;
        builder.pk.entrySet().stream().forEach(pk -> {
            this.columnDefinitions.add((ColumnDefinition)pk.getValue());
            this.primaryKey.getPartitionKey().add((String)pk.getKey());
        });
        builder.cc.entrySet().stream().forEach(cc -> {
            this.columnDefinitions.add((ColumnDefinition)cc.getValue());
            this.primaryKey.getClusteringKey().add((String)cc.getKey());
            this.tableOptions.getClusteringExpression().add(new ClusteringExpression((String)cc.getKey(), (Ordering)builder.ccOrder.get(cc.getKey())));
        });
        builder.cols.entrySet().stream().forEach(col -> this.columnDefinitions.add((ColumnDefinition)col.getValue()));
    }

    public static CreateTableBuilder builder() {
        return new CreateTableBuilder();
    }

    public TablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(TablePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class CreateTableBuilder {
        private String name;
        private boolean ifNotExists = false;
        private Map<String, ColumnDefinition> pk = new HashMap<String, ColumnDefinition>();
        private Map<String, ColumnDefinition> cc = new HashMap<String, ColumnDefinition>();
        private Map<String, Ordering> ccOrder = new HashMap<String, Ordering>();
        private Map<String, ColumnDefinition> cols = new HashMap<String, ColumnDefinition>();

        public CreateTableBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateTableBuilder ifNotExist(boolean ine) {
            this.ifNotExists = ine;
            return this;
        }

        public CreateTableBuilder addColumnStatic(String name, String type) {
            if (this.pk.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as partition key");
            }
            if (this.cc.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as clustering key");
            }
            if (this.cols.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as simple column");
            }
            this.cols.put(name, new ColumnDefinition(name, type, true));
            return this;
        }

        public CreateTableBuilder addColumn(String name, String type) {
            if (this.pk.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as partition key");
            }
            if (this.cc.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as clustering key");
            }
            if (this.cols.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add simple column " + name + ", it has already been defined as simple column");
            }
            this.cols.put(name, new ColumnDefinition(name, type));
            return this;
        }

        public CreateTableBuilder addPartitionKey(String name, String type) {
            if (this.pk.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as partition key");
            }
            if (this.cc.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as clustering key");
            }
            if (this.cols.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as simple column");
            }
            this.pk.put(name, new ColumnDefinition(name, type));
            return this;
        }

        public CreateTableBuilder addClusteringKey(String name, String type, Ordering order) {
            if (this.pk.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as partition key");
            }
            if (this.cc.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as clustering key");
            }
            if (this.cols.containsKey(name)) {
                throw new IllegalArgumentException("Cannot add partitionKey column " + name + ", it has already been defined as simple column");
            }
            this.cc.put(name, new ColumnDefinition(name, type));
            this.ccOrder.put(name, order);
            return this;
        }

        public CreateTable build() {
            return new CreateTable(this);
        }
    }
}

