/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest.domain;

import io.stargate.sdk.core.Ordering;
import io.stargate.sdk.core.Sort;
import io.stargate.sdk.utils.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class QueryWithKey {
    public static final int PAGING_SIZE_MAX = 20;
    public static final int DEFAULT_PAGING_SIZE = 20;
    private final int pageSize;
    private final String pageState;
    private final List<String> fieldsToRetrieve;
    private final List<Sort> fieldsToSort;

    public static QueryRowBuilder builder() {
        return new QueryRowBuilder();
    }

    private QueryWithKey(QueryRowBuilder builder) {
        this.pageSize = builder.pageSize;
        this.pageState = builder.pageState;
        this.fieldsToRetrieve = builder.fieldsToRetrieve;
        this.fieldsToSort = builder.fieldsToSort;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }

    public List<String> getFieldsToRetrieve() {
        return this.fieldsToRetrieve;
    }

    public List<Sort> getFieldsToSort() {
        return this.fieldsToSort;
    }

    public static class QueryRowBuilder {
        protected int pageSize = 20;
        protected String pageState = null;
        protected List<String> fieldsToRetrieve = new ArrayList<String>();
        protected List<Sort> fieldsToSort = new ArrayList<Sort>();

        public QueryWithKey build() {
            return new QueryWithKey(this);
        }

        public QueryRowBuilder withPageSize(int pageSize) {
            if (pageSize < 1 || pageSize > 20) {
                throw new IllegalArgumentException("Page size should be between 1 and 100");
            }
            this.pageSize = pageSize;
            return this;
        }

        public QueryRowBuilder withPageState(String pageState) {
            Assert.hasLength((String)pageState, (String)"pageState");
            this.pageState = pageState;
            return this;
        }

        public QueryRowBuilder returnedFields(String ... fields) {
            Assert.notNull((Object)fields, (String)"fields");
            this.fieldsToRetrieve = new ArrayList<String>(Arrays.asList(fields));
            return this;
        }

        public QueryRowBuilder addReturnedField(String fieldname) {
            Assert.hasLength((String)fieldname, (String)"fieldname");
            this.fieldsToRetrieve.add(fieldname);
            return this;
        }

        public QueryRowBuilder sortedFields(Sort ... fields) {
            Assert.notNull((Object)fields, (String)"fields");
            this.fieldsToSort = new ArrayList<Sort>(Arrays.asList(fields));
            return this;
        }

        public QueryRowBuilder addSortedField(String fieldname, Ordering order) {
            Assert.hasLength((String)fieldname, (String)"fieldname");
            Assert.notNull((Object)order, (String)"order");
            this.fieldsToSort.add(new Sort(fieldname, order));
            return this;
        }
    }
}

