/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.TableClient;
import io.stargate.sdk.rest.domain.ColumnDefinition;
import io.stargate.sdk.rest.exception.ColumnsNotFoundException;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Optional;
import java.util.function.Function;

public class ColumnsClient {
    private final LoadBalancedHttpClient stargateClient;
    private TableClient tableClient;
    private String columnId;
    private final TypeReference<ApiResponse<ColumnDefinition>> TYPE_COLUMN_DEF = new TypeReference<ApiResponse<ColumnDefinition>>(){};
    public Function<ServiceHttp, String> columnSchemaResource = node -> this.tableClient.columnsSchemaResource.apply((ServiceHttp)node) + "/" + this.columnId;

    public ColumnsClient(LoadBalancedHttpClient stargateHttpClient, TableClient tableClient, String columnId) {
        this.tableClient = tableClient;
        this.stargateClient = stargateHttpClient;
        this.columnId = columnId;
        Assert.hasLength((String)columnId, (String)"columnId");
    }

    public Optional<ColumnDefinition> find() {
        ApiResponseHttp res = this.stargateClient.GET(this.columnSchemaResource);
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ColumnDefinition)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), this.TYPE_COLUMN_DEF)).getData());
    }

    public boolean exist() {
        return this.find().isPresent();
    }

    public void create(ColumnDefinition cd) {
        Assert.notNull((Object)cd, (String)"ColumnDefinition");
        this.stargateClient.POST(this.tableClient.columnsSchemaResource, JsonUtils.marshall((Object)cd));
    }

    public void delete() {
        ApiResponseHttp res = this.stargateClient.DELETE(this.columnSchemaResource);
        if (404 == res.getCode()) {
            throw new ColumnsNotFoundException(this.columnId);
        }
    }

    public void rename(String newName) {
        Assert.hasLength((String)newName, (String)"New columns name");
        Assert.isTrue((Boolean)(!newName.equalsIgnoreCase(this.columnId) ? 1 : 0), (String)"You should not rename with same name");
        String body = JsonUtils.marshall((Object)new ColumnDefinition(newName, this.find().get().getTypeDefinition()));
        this.stargateClient.PUT(this.columnSchemaResource, body);
    }
}

