/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.TableClient;
import io.stargate.sdk.rest.domain.CreateIndex;
import io.stargate.sdk.rest.domain.IndexDefinition;
import io.stargate.sdk.rest.exception.IndexNotFoundException;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Optional;
import java.util.function.Function;

public class IndexClient {
    private final LoadBalancedHttpClient stargateClient;
    private TableClient tableClient;
    private String indexName;
    public Function<ServiceHttp, String> indexSchemaResource = node -> this.tableClient.indexesSchemaResource.apply((ServiceHttp)node) + "/" + this.indexName;

    public IndexClient(LoadBalancedHttpClient stargateHttpClient, TableClient tableClient, String indexName) {
        this.tableClient = tableClient;
        this.stargateClient = stargateHttpClient;
        this.indexName = indexName;
        Assert.hasLength((String)indexName, (String)"indexName");
    }

    public Optional<IndexDefinition> find() {
        return this.tableClient.indexes().filter(i -> this.indexName.equalsIgnoreCase(i.getIndex_name())).findFirst();
    }

    public boolean exist() {
        return this.tableClient.indexesNames().anyMatch(this.indexName::equals);
    }

    public void create(CreateIndex ci) {
        Assert.notNull((Object)ci, (String)"CreateIndex");
        ci.setName(this.indexName);
        System.out.println(JsonUtils.marshall((Object)ci));
        this.stargateClient.POST(this.tableClient.indexesSchemaResource, JsonUtils.marshall((Object)ci));
    }

    public void delete() {
        ApiResponseHttp res = this.stargateClient.DELETE(this.indexSchemaResource);
        if (404 == res.getCode()) {
            throw new IndexNotFoundException(this.indexName);
        }
    }
}

