/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.core.Sort;
import io.stargate.sdk.core.domain.ObjectMap;
import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.core.domain.RowMapper;
import io.stargate.sdk.core.domain.RowResultPage;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.TableClient;
import io.stargate.sdk.rest.domain.QueryWithKey;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KeyClient {
    private final LoadBalancedHttpClient stargateClient;
    private TableClient tableClient;
    private List<Object> key;
    private static final TypeReference<ApiResponse<List<LinkedHashMap<String, ?>>>> TYPE_RESULTS = new TypeReference<ApiResponse<List<LinkedHashMap<String, ?>>>>(){};
    public Function<ServiceHttp, String> primaryKeyResource = node -> {
        StringBuilder sbUrl = new StringBuilder(this.tableClient.tableResource.apply((ServiceHttp)node));
        try {
            for (Object pk : this.key) {
                sbUrl.append("/" + URLEncoder.encode(pk.toString(), StandardCharsets.UTF_8.toString()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot enode URL", e);
        }
        return sbUrl.toString();
    };

    public KeyClient(LoadBalancedHttpClient stargateHttpClient, TableClient tableClient, Object ... keys) {
        this.tableClient = tableClient;
        this.key = new ArrayList<Object>(Arrays.asList(keys));
        this.stargateClient = stargateHttpClient;
        Assert.notNull(this.key, (String)"key");
        Assert.isTrue((Boolean)(!this.key.isEmpty() ? 1 : 0), (String)"key");
    }

    public Stream<ObjectMap> findAll() {
        ArrayList objectMaps = new ArrayList();
        String pageState = null;
        do {
            RowResultPage pageX;
            pageState = (pageX = this.findPage(20, pageState)).getPageState().isPresent() ? (String)pageX.getPageState().get() : null;
            objectMaps.addAll(pageX.getResults());
        } while (pageState != null);
        return objectMaps.stream();
    }

    public <T> Stream<T> findAll(RowMapper<T> rowMapper) {
        return this.findAll().map(arg_0 -> rowMapper.map(arg_0));
    }

    public RowResultPage findFirstPage(int pageSize) {
        return this.findPage(pageSize, null);
    }

    public RowResultPage findPage(int pageSize, String pageState) {
        QueryWithKey.QueryRowBuilder builder = QueryWithKey.builder().withPageSize(pageSize);
        if (null != pageState) {
            builder.withPageState(pageState);
        }
        return this.findPage(builder.build());
    }

    public RowResultPage findPage(QueryWithKey query) {
        Objects.requireNonNull(query);
        ApiResponseHttp res = this.stargateClient.GET(this.primaryKeyResource, this.buildSearchUrlSuffix(query));
        System.out.println(res.getBody());
        ApiResponse result = (ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), TYPE_RESULTS);
        return new RowResultPage(query.getPageSize(), result.getPageState(), ((List)result.getData()).stream().map(map -> {
            ObjectMap r = new ObjectMap();
            r.putAll((Map)map);
            return r;
        }).collect(Collectors.toList()));
    }

    public <T> Page<T> findPage(QueryWithKey query, RowMapper<T> mapper) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(mapper);
        return this.mapAsResultPage(this.findPage(query), mapper);
    }

    private <T> Page<T> mapAsResultPage(RowResultPage rrp, RowMapper<T> mapper) {
        return new Page(rrp.getPageSize(), (String)rrp.getPageState().orElse(null), rrp.getResults().stream().map(arg_0 -> mapper.map(arg_0)).collect(Collectors.toList()));
    }

    public void delete() {
        this.stargateClient.DELETE(this.primaryKeyResource);
    }

    public void update(Map<String, Object> newRecord) {
        this.stargateClient.PATCH(this.primaryKeyResource, JsonUtils.marshall(newRecord));
    }

    public void replace(Map<String, Object> newRecord) {
        this.stargateClient.PUT(this.primaryKeyResource, JsonUtils.marshall(newRecord));
    }

    private String buildSearchUrlSuffix(QueryWithKey query) {
        try {
            StringBuilder sbUrl = new StringBuilder();
            sbUrl.append("?page-size=" + query.getPageSize());
            if (query.getPageState().isPresent()) {
                sbUrl.append("&page-state=" + URLEncoder.encode(query.getPageState().get(), StandardCharsets.UTF_8.toString()));
            }
            if (null != query.getFieldsToRetrieve() && !query.getFieldsToRetrieve().isEmpty()) {
                sbUrl.append("&fields=" + URLEncoder.encode(JsonUtils.collectionAsJson(query.getFieldsToRetrieve()), StandardCharsets.UTF_8.toString()));
            }
            if (null != query.getFieldsToSort() && !query.getFieldsToSort().isEmpty()) {
                LinkedHashMap<String, String> sortFields = new LinkedHashMap<String, String>();
                for (Sort sf : query.getFieldsToSort()) {
                    sortFields.put(sf.getFieldName(), sf.getOrder().name());
                }
                sbUrl.append("&sort=" + URLEncoder.encode(JsonUtils.mapAsJson(sortFields), StandardCharsets.UTF_8.toString()));
            }
            return sbUrl.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot enode URL", e);
        }
    }
}

