/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.core.DataCenter;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.rest.StargateRestApiClient;
import io.stargate.sdk.rest.TableClient;
import io.stargate.sdk.rest.TypeClient;
import io.stargate.sdk.rest.domain.CreateTable;
import io.stargate.sdk.rest.domain.Keyspace;
import io.stargate.sdk.rest.domain.TableDefinition;
import io.stargate.sdk.rest.domain.TypeDefinition;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KeyspaceClient {
    public static final String PATH_KEYSPACES = "/v2/keyspaces";
    public static final String PATH_TABLES = "/tables";
    public static final String PATH_TYPES = "/types";
    private static final TypeReference<ApiResponse<Keyspace>> RESPONSE_KEYSPACE = new TypeReference<ApiResponse<Keyspace>>(){};
    private static final TypeReference<ApiResponse<List<TableDefinition>>> RESPONSE_TABLE_DEFINITIONS = new TypeReference<ApiResponse<List<TableDefinition>>>(){};
    private static final TypeReference<ApiResponse<List<TypeDefinition>>> RESPONSE_TYPE_DEFINITIONS = new TypeReference<ApiResponse<List<TypeDefinition>>>(){};
    private StargateRestApiClient apiData = null;
    private String keyspace;
    private Map<String, TableClient> tablesClient = new HashMap<String, TableClient>();
    private Map<String, TypeClient> typesClient = new HashMap<String, TypeClient>();
    public Function<ServiceHttp, String> keyspaceResource = node -> this.apiData.keyspacesResource.apply((ServiceHttp)node) + "/" + this.keyspace;
    public Function<ServiceHttp, String> keyspaceSchemaResource = node -> this.apiData.keyspacesSchemaResource.apply((ServiceHttp)node) + "/" + this.keyspace;
    public Function<ServiceHttp, String> tablesResource = node -> this.keyspaceResource.apply((ServiceHttp)node) + PATH_TABLES;
    public Function<ServiceHttp, String> tablesSchemaResource = node -> this.keyspaceSchemaResource.apply((ServiceHttp)node) + PATH_TABLES;
    public Function<ServiceHttp, String> typesResource = node -> this.keyspaceResource.apply((ServiceHttp)node) + PATH_TYPES;
    public Function<ServiceHttp, String> typesSchemaResource = node -> this.keyspaceSchemaResource.apply((ServiceHttp)node) + PATH_TYPES;

    public KeyspaceClient(StargateRestApiClient apiData, String keyspace) {
        this.apiData = apiData;
        this.keyspace = keyspace;
        Assert.hasLength((String)keyspace, (String)"keyspace");
    }

    public Optional<Keyspace> find() {
        ApiResponseHttp res = this.apiData.stargateHttpClient.GET(this.keyspaceSchemaResource);
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of((Keyspace)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), RESPONSE_KEYSPACE)).getData());
    }

    public boolean exist() {
        return this.find().isPresent();
    }

    public void create(DataCenter ... datacenters) {
        Assert.notNull((Object)datacenters, (String)"datacenters");
        Assert.isTrue((Boolean)(datacenters.length > 0 ? 1 : 0), (String)"DataCenters are required");
        System.out.println(JsonUtils.marshall((Object)new Keyspace(this.keyspace, Arrays.asList(datacenters))));
        this.apiData.stargateHttpClient.POST(this.apiData.keyspacesSchemaResource, JsonUtils.marshall((Object)new Keyspace(this.keyspace, Arrays.asList(datacenters))));
    }

    public void createSimple(int replicas) {
        Assert.isTrue((Boolean)(replicas > 0 ? 1 : 0), (String)"Replica number should be bigger than 0");
        this.apiData.stargateHttpClient.POST(this.apiData.keyspacesSchemaResource, JsonUtils.marshall((Object)new Keyspace(this.keyspace, replicas)));
    }

    public void delete() {
        this.apiData.stargateHttpClient.DELETE(this.keyspaceSchemaResource);
    }

    public Stream<TableDefinition> tables() {
        return ((List)((ApiResponse)JsonUtils.unmarshallType((String)this.apiData.stargateHttpClient.GET(this.tablesSchemaResource).getBody(), RESPONSE_TABLE_DEFINITIONS)).getData()).stream();
    }

    public Map<String, TableDefinition> tablesAsMap() {
        return this.tables().collect(Collectors.toMap(TableDefinition::getName, Function.identity()));
    }

    public Stream<TypeDefinition> types() {
        return ((List)((ApiResponse)JsonUtils.unmarshallType((String)this.apiData.stargateHttpClient.GET(this.typesSchemaResource).getBody(), RESPONSE_TYPE_DEFINITIONS)).getData()).stream();
    }

    public Stream<String> tableNames() {
        return this.tables().map(TableDefinition::getName);
    }

    public Stream<String> typeNames() {
        return this.types().map(TypeDefinition::getName);
    }

    public TableClient table(String tableName) {
        Assert.hasLength((String)tableName, (String)"tableName");
        if (!this.tablesClient.containsKey(tableName)) {
            this.tablesClient.put(tableName, new TableClient(this.apiData.stargateHttpClient, this, tableName));
        }
        return this.tablesClient.get(tableName);
    }

    public TypeClient type(String typeName) {
        Assert.hasLength((String)typeName, (String)"typeName");
        if (!this.typesClient.containsKey(typeName)) {
            this.typesClient.put(typeName, new TypeClient(this.apiData.stargateHttpClient, this, typeName));
        }
        return this.typesClient.get(typeName);
    }

    public void createTable(String tableName, CreateTable ct) {
        this.table(tableName).create(ct);
    }

    public String getKeyspace() {
        return this.keyspace;
    }
}

