/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateIndex
implements Serializable {
    private static final long serialVersionUID = -5374080080154230782L;
    public static final String TYPE_SASI = "org.apache.cassandra.index.sasi.SASIIndex";
    public static final String TYPE_SAI = "org.apache.cassandra.index.sai.StorageAttachedIndex";
    private String name;
    private final String column;
    private final boolean ifNotExists;
    private final String type;
    private final IndexKind kind;
    private final Map<String, String> options;

    private CreateIndex(CreateIndexBuilder builder) {
        this.name = builder.name;
        this.column = builder.column;
        this.ifNotExists = builder.ifNotExists;
        this.type = builder.type;
        this.kind = builder.kind;
        this.options = builder.options;
    }

    public static CreateIndexBuilder builder() {
        return new CreateIndexBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public String getType() {
        return this.type;
    }

    public IndexKind getKind() {
        return this.kind;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class CreateIndexBuilder {
        boolean ifNotExists = false;
        String name;
        String column;
        String type = null;
        IndexKind kind = null;
        Map<String, String> options = null;

        public CreateIndex build() {
            return new CreateIndex(this);
        }

        public CreateIndexBuilder ifNotExist(boolean ine) {
            this.ifNotExists = ine;
            return this;
        }

        public CreateIndexBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateIndexBuilder type(String t) {
            this.type = t;
            return this;
        }

        public CreateIndexBuilder sasi() {
            return this.type(CreateIndex.TYPE_SASI);
        }

        public CreateIndexBuilder sai() {
            return this.type(CreateIndex.TYPE_SAI);
        }

        public CreateIndexBuilder column(String name) {
            this.column = name;
            return this;
        }

        public CreateIndexBuilder kind(IndexKind k) {
            this.kind = k;
            return this;
        }

        public CreateIndexBuilder addOption(String key, String value) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(key, value);
            return this;
        }
    }

    private static enum IndexKind {
        KEYS,
        VALUES,
        ENTRIES,
        FULL;

    }
}

