/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.rest.domain;

import io.stargate.sdk.core.Sort;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.http.domain.FilterOperator;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SearchTableQuery {
    public static final int PAGING_SIZE_MAX = 20;
    public static final int DEFAULT_PAGING_SIZE = 20;
    private final int pageSize;
    private final String pageState;
    private final String where;
    private final List<String> fieldsToRetrieve;
    private final List<Sort> fieldsToSort;

    public static SearchTableQueryBuilder builder() {
        return new SearchTableQueryBuilder();
    }

    private SearchTableQuery(SearchTableQueryBuilder builder) {
        this.pageSize = builder.pageSize;
        this.pageState = builder.pageState;
        this.fieldsToRetrieve = builder.fieldsToRetrieve;
        this.fieldsToSort = builder.fieldsToSort;
        this.where = builder.getWhereClause();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }

    public Optional<String> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public List<String> getFieldsToRetrieve() {
        return this.fieldsToRetrieve;
    }

    public List<Sort> getFieldsToSort() {
        return this.fieldsToSort;
    }

    public static class SearchTableQueryBuilder {
        protected int pageSize = 20;
        protected String pageState = null;
        protected List<String> fieldsToRetrieve = new ArrayList<String>();
        protected List<Sort> fieldsToSort = new ArrayList<Sort>();
        protected String whereClause;
        protected List<Filter> filters = new ArrayList<Filter>();

        public SearchTableQuery build() {
            return new SearchTableQuery(this);
        }

        public SearchTableQueryBuilder withPageSize(int pageSize) {
            if (pageSize < 1 || pageSize > 20) {
                throw new IllegalArgumentException("Page size should be between 1 and 100");
            }
            this.pageSize = pageSize;
            return this;
        }

        public SearchTableQueryBuilder withPageState(String pageState) {
            Assert.hasLength((String)pageState, (String)"pageState");
            this.pageState = pageState;
            return this;
        }

        public SearchTableQueryBuilder withReturnedFields(String ... fields) {
            Assert.notNull((Object)fields, (String)"fields");
            this.fieldsToRetrieve = new ArrayList<String>(Arrays.asList(fields));
            this.fieldsToRetrieve.remove("");
            this.fieldsToRetrieve.remove(null);
            return this;
        }

        public SearchTableQueryBuilder select(String ... fields) {
            return this.withReturnedFields(fields);
        }

        public SearchTableQueryBuilder withSortedFields(Sort ... fields) {
            Assert.notNull((Object)fields, (String)"fields");
            this.fieldsToSort = new ArrayList<Sort>(Arrays.asList(fields));
            return this;
        }

        public SearchTableQueryBuilder sortBy(Sort ... fields) {
            return this.withSortedFields(fields);
        }

        public SearchTableQueryBuilder withWhereClauseJson(String where) {
            if (this.whereClause != null) {
                throw new IllegalArgumentException("Only a single where clause is allowd in a query");
            }
            Assert.hasLength((String)where, (String)"where");
            this.whereClause = where;
            return this;
        }

        public SearchTableWhere where(String fieldName) {
            Assert.hasLength((String)fieldName, (String)"fieldName");
            return new SearchTableWhere(this, fieldName);
        }

        public String getWhereClause() {
            if (Utils.hasLength((String)this.whereClause)) {
                return this.whereClause;
            }
            return "{" + this.filters.stream().map(Filter::toString).collect(Collectors.joining(",")) + "}";
        }
    }

    public static class SearchTableWhere {
        private final String fieldName;
        private final SearchTableQueryBuilder builder;

        protected SearchTableWhere(SearchTableQueryBuilder builder, String fieldName) {
            this.builder = builder;
            this.fieldName = fieldName;
        }

        private SearchTableQueryBuilder addFilter(FilterOperator op, Object value) {
            this.builder.filters.add(new Filter(this.fieldName, op, value));
            return this.builder;
        }

        public SearchTableQueryBuilder isLessThan(Object value) {
            return this.addFilter(FilterOperator.LESS_THAN, value);
        }

        public SearchTableQueryBuilder isLessOrEqualsThan(Object value) {
            return this.addFilter(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
        }

        public SearchTableQueryBuilder isGreaterThan(Object value) {
            return this.addFilter(FilterOperator.GREATER_THAN, value);
        }

        public SearchTableQueryBuilder isGreaterOrEqualsThan(Object value) {
            return this.addFilter(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
        }

        public SearchTableQueryBuilder isEqualsTo(Object value) {
            return this.addFilter(FilterOperator.EQUALS_TO, value);
        }

        public SearchTableQueryBuilder isNotEqualsTo(Object value) {
            return this.addFilter(FilterOperator.NOT_EQUALS_TO, value);
        }

        public SearchTableQueryBuilder exists() {
            return this.addFilter(FilterOperator.EXISTS, null);
        }

        public SearchTableQueryBuilder isIn(Collection<Object> values) {
            return this.addFilter(FilterOperator.IN, values);
        }

        public SearchTableQueryBuilder contains(Object value) {
            return this.addFilter(FilterOperator.CONTAINS, value);
        }

        public SearchTableQueryBuilder containsKey(Object value) {
            return this.addFilter(FilterOperator.CONTAIN_KEY, value);
        }

        public SearchTableQueryBuilder containsEntry(Object value) {
            return this.addFilter(FilterOperator.CONTAIN_ENTRY, value);
        }
    }
}

