/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.evanlennick.retry4j.config.RetryConfig;
import io.stargate.sdk.StargateClient;
import io.stargate.sdk.StargateDataCenter;
import io.stargate.sdk.api.SimpleTokenProvider;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.config.RequestConfig;

public class StargateClientBuilder
implements Serializable {
    private static final long serialVersionUID = -4662012136342903695L;
    public static final String DEFAULT_DATACENTER = "dc1";
    protected String username;
    protected String password;
    protected String appToken = null;
    protected Map<String, StargateDataCenter> stargateNodesDC = new HashMap<String, StargateDataCenter>();
    protected String localDatacenter;
    protected boolean enabledCql = false;
    protected CqlSession cqlSession = null;
    protected ProgrammaticDriverConfigLoaderBuilder driverConfig = new DefaultProgrammaticDriverConfigLoaderBuilder();
    protected OptionsMap cqlOptions = OptionsMap.driverDefaults();
    protected Object cqlMetricsRegistry;
    protected RequestTracker cqlRequestTracker;
    protected boolean enabledGrpc = false;
    protected RetryConfig httpRetryConfig;
    protected RequestConfig httpRequestConfig;
    protected Map<String, ServiceCallObserver> httpObservers = new HashMap<String, ServiceCallObserver>();

    public Map<String, StargateDataCenter> getStargateNodesDC() {
        return this.stargateNodesDC;
    }

    public StargateClientBuilder withAuthCredentials(String username, String password) {
        this.checkNoCqlSession();
        Assert.hasLength((String)username, (String)"username");
        Assert.hasLength((String)password, (String)"password");
        this.username = username;
        this.password = password;
        this.withCqlOptionString((TypedDriverOption<String>)TypedDriverOption.AUTH_PROVIDER_USER_NAME, username);
        this.withCqlOptionString((TypedDriverOption<String>)TypedDriverOption.AUTH_PROVIDER_PASSWORD, password);
        this.withCqlOptionString((TypedDriverOption<String>)TypedDriverOption.AUTH_PROVIDER_CLASS, PlainTextAuthProvider.class.getName());
        return this;
    }

    public TokenProvider getApiTokenProvider(String dc) {
        Assert.hasLength((String)dc, (String)"dc");
        SimpleTokenProvider dcTokenProvider = null;
        if (Utils.hasLength((String)this.appToken)) {
            dcTokenProvider = new SimpleTokenProvider(this.appToken);
        } else if (this.stargateNodesDC.containsKey(dc)) {
            dcTokenProvider = this.stargateNodesDC.get(dc).getTokenProvider();
        } else {
            throw new IllegalArgumentException("No token provider found for DC" + dc);
        }
        return dcTokenProvider;
    }

    public StargateClientBuilder withApiToken(String token) {
        Assert.hasLength((String)token, (String)"token");
        this.appToken = token;
        return this;
    }

    public StargateClientBuilder withApiTokenProvider(String ... url) {
        Assert.notNull((Object)url, (String)"url list");
        return this.withApiTokenProviderDC(this.localDatacenter, url);
    }

    public StargateClientBuilder withApiTokenProviderDC(String dc, TokenProvider tokenProvider) {
        Assert.hasLength((String)dc, (String)"dc");
        if (!this.stargateNodesDC.containsKey(dc)) {
            this.stargateNodesDC.put(dc, new StargateDataCenter(dc, tokenProvider));
        }
        this.stargateNodesDC.get(dc).setTokenProvider(tokenProvider);
        return this;
    }

    public StargateClientBuilder withApiTokenProviderDC(String dc, String ... url) {
        Assert.hasLength((String)dc, (String)"dc");
        Assert.notNull((Object)url, (String)"url list");
        if (!Utils.hasLength((String)this.username)) {
            throw new IllegalStateException("Username is empty please .withAuthCredentials() before .withApiTokenProvider()");
        }
        return this.withApiTokenProviderDC(dc, (TokenProvider)new TokenProviderHttpAuth(this.username, this.password, url));
    }

    public StargateClientBuilder addServiceRest(ServiceHttp rest) {
        return this.addServiceRest(this.localDatacenter, rest);
    }

    public StargateClientBuilder addServiceRest(String dc, ServiceHttp rest) {
        if (!this.stargateNodesDC.containsKey(dc)) {
            this.stargateNodesDC.put(dc, new StargateDataCenter(dc));
        }
        this.stargateNodesDC.get(dc).addRestService(rest);
        return this;
    }

    public StargateClientBuilder addDocumentService(String dc, ServiceHttp rest) {
        if (!this.stargateNodesDC.containsKey(dc)) {
            this.stargateNodesDC.put(dc, new StargateDataCenter(dc));
        }
        this.stargateNodesDC.get(dc).addDocumenService(rest);
        return this;
    }

    public StargateClientBuilder addDocumentService(ServiceHttp doc) {
        return this.addDocumentService(this.localDatacenter, doc);
    }

    public StargateClientBuilder addGraphQLService(String dc, ServiceHttp rest) {
        if (!this.stargateNodesDC.containsKey(dc)) {
            this.stargateNodesDC.put(dc, new StargateDataCenter(dc));
        }
        this.stargateNodesDC.get(dc).addGraphQLService(rest);
        return this;
    }

    public StargateClientBuilder addGraphQLService(ServiceHttp rest) {
        return this.addGraphQLService(this.localDatacenter, rest);
    }

    public StargateClientBuilder addGrpcService(String dc, ServiceGrpc grpc) {
        if (!this.stargateNodesDC.containsKey(dc)) {
            this.stargateNodesDC.put(dc, new StargateDataCenter(dc));
        }
        this.stargateNodesDC.get(dc).addGrpcService(grpc);
        return this;
    }

    public StargateClientBuilder addGrpcService(ServiceGrpc grpc) {
        return this.addGrpcService(this.localDatacenter, grpc);
    }

    public StargateClientBuilder withLocalDatacenter(String localDc) {
        Assert.hasLength((String)localDc, (String)"localDc");
        this.setLocalDatacenter(localDc);
        this.driverConfig.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, localDc);
        this.driverConfig.withBoolean((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS, true);
        this.cqlOptions.put(TypedDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, (Object)localDc);
        this.cqlOptions.put(TypedDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS, (Object)true);
        return this;
    }

    public String getLocalDatacenter() {
        return this.localDatacenter;
    }

    public void setLocalDatacenter(String localDc) {
        this.localDatacenter = localDc;
    }

    public StargateClientBuilder enableCql() {
        this.enabledCql = true;
        return this;
    }

    public StargateClientBuilder withCqlSession(CqlSession cql) {
        Assert.notNull((Object)cql, (String)"cqlSession");
        this.checkNoCqlSession();
        this.enableCql();
        this.cqlSession = cql;
        return this;
    }

    public StargateClientBuilder withCqlDriverConfigurationFile(File configFile) {
        Assert.notNull((Object)configFile, (String)"configFile");
        Assert.isTrue((Boolean)configFile.exists(), (String)"Config file should exists");
        return this.withCqlSession((CqlSession)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(DriverConfigLoader.fromFile((File)configFile))).build());
    }

    public StargateClientBuilder withCqlDriverConfigLoaderBuilder(ProgrammaticDriverConfigLoaderBuilder pdclb) {
        this.driverConfig = pdclb;
        return this;
    }

    public StargateClientBuilder withCqlOptionBoolean(TypedDriverOption<Boolean> option, Boolean du) {
        this.driverConfig.withBoolean(option.getRawOption(), du.booleanValue());
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionBooleanDC(String dc, TypedDriverOption<Boolean> option, Boolean du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withBoolean(option.getRawOption(), du.booleanValue())).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionBooleanList(TypedDriverOption<List<Boolean>> option, List<Boolean> du) {
        this.driverConfig.withBooleanList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionBooleanListDC(String dc, TypedDriverOption<List<Boolean>> option, List<Boolean> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withBooleanList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionClass(TypedDriverOption<Class<?>> option, Class<?> du) {
        this.driverConfig.withClass(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionClassDC(String dc, TypedDriverOption<Class<?>> option, Class<?> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withClass(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionClassList(TypedDriverOption<List<Class<?>>> option, List<Class<?>> du) {
        this.driverConfig.withClassList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionClassListDC(String dc, TypedDriverOption<List<Class<?>>> option, List<Class<?>> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withClassList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDouble(TypedDriverOption<Double> option, Double du) {
        this.driverConfig.withDouble(option.getRawOption(), du.doubleValue());
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDoubleDC(String dc, TypedDriverOption<Double> option, Double du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withDouble(option.getRawOption(), du.doubleValue())).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDoubleList(TypedDriverOption<List<Double>> option, List<Double> du) {
        this.driverConfig.withDoubleList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDoubleListDC(String dc, TypedDriverOption<List<Double>> option, List<Double> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withDoubleList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDuration(TypedDriverOption<Duration> option, Duration du) {
        this.driverConfig.withDuration(option.getRawOption(), du);
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDurationDC(String dc, TypedDriverOption<Duration> option, Duration du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withDuration(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDurationList(TypedDriverOption<List<Duration>> option, List<Duration> du) {
        this.driverConfig.withDurationList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionDurationListDC(String dc, TypedDriverOption<List<Duration>> option, List<Duration> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withDurationList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionInteger(TypedDriverOption<Integer> option, Integer du) {
        this.driverConfig.withInt(option.getRawOption(), du.intValue());
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionIntegerDC(String dc, TypedDriverOption<Integer> option, Integer du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withInt(option.getRawOption(), du.intValue())).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionIntegerList(TypedDriverOption<List<Integer>> option, List<Integer> du) {
        this.driverConfig.withIntList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionIntegerListDC(String dc, TypedDriverOption<List<Integer>> option, List<Integer> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withIntList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionLong(TypedDriverOption<Long> option, Long du) {
        this.driverConfig.withLong(option.getRawOption(), du.longValue());
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionLongDC(String dc, TypedDriverOption<Long> option, Long du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withLong(option.getRawOption(), du.longValue())).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionLongList(TypedDriverOption<List<Long>> option, List<Long> du) {
        this.driverConfig.withLongList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionLongListDC(String dc, TypedDriverOption<List<Long>> option, List<Long> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withLongList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionString(TypedDriverOption<String> option, String du) {
        this.driverConfig.withString(option.getRawOption(), du);
        this.cqlOptions.put(option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionStringDC(String dc, TypedDriverOption<String> option, String du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withString(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, (Object)du);
        return this;
    }

    public StargateClientBuilder withCqlOptionStringList(TypedDriverOption<List<String>> option, List<String> du) {
        this.driverConfig.withStringList(option.getRawOption(), du);
        this.cqlOptions.put(option, du);
        return this;
    }

    public StargateClientBuilder withCqlOptionStringListDC(String dc, TypedDriverOption<List<String>> option, List<String> du) {
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withStringList(option.getRawOption(), du)).endProfile();
        this.cqlOptions.put(dc, option, du);
        return this;
    }

    public StargateClientBuilder withCqlMetricsRegistry(Object registry) {
        Assert.notNull((Object)registry, (String)"registry");
        this.checkNoCqlSession();
        this.cqlMetricsRegistry = registry;
        return this;
    }

    public StargateClientBuilder withCqlRequestTracker(RequestTracker cqlReqTracker) {
        Assert.notNull((Object)cqlReqTracker, (String)"RequestTracker");
        this.checkNoCqlSession();
        this.cqlRequestTracker = cqlReqTracker;
        return this;
    }

    public StargateClientBuilder withCqlConsistencyLevel(ConsistencyLevel cl) {
        Assert.notNull((Object)cl, (String)"consistency level");
        this.driverConfig.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, cl.name());
        this.cqlOptions.put(this.localDatacenter, TypedDriverOption.REQUEST_CONSISTENCY, (Object)cl.name());
        return this;
    }

    public StargateClientBuilder withCqlConsistencyLevelDC(String dc, ConsistencyLevel cl) {
        Assert.hasLength((String)dc, (String)"dc, datacenter name");
        Assert.notNull((Object)cl, (String)"consistency level");
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, cl.name())).endProfile();
        this.cqlOptions.put(dc, TypedDriverOption.REQUEST_CONSISTENCY, (Object)cl.name());
        return this;
    }

    public StargateClientBuilder withCqlContactPoints(String ... contactPoints) {
        Assert.notNull((Object)contactPoints, (String)"contactPoints");
        Assert.isTrue((Boolean)(contactPoints.length > 0 ? 1 : 0), (String)"contactPoints should not be null");
        Assert.hasLength((String)contactPoints[0], (String)"one contact point");
        this.driverConfig.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, Arrays.asList(contactPoints));
        this.cqlOptions.put(this.localDatacenter, TypedDriverOption.CONTACT_POINTS, Arrays.asList(contactPoints));
        return this;
    }

    public StargateClientBuilder withCqlContactPointsDC(String dc, String ... contactPoints) {
        Assert.notNull((Object)contactPoints, (String)"contactPoints");
        Assert.isTrue((Boolean)(contactPoints.length > 0 ? 1 : 0), (String)"contactPoints should not be null");
        Assert.hasLength((String)contactPoints[0], (String)"one contact point");
        Assert.hasLength((String)dc, (String)"dc, datacenter name");
        ((ProgrammaticDriverConfigLoaderBuilder)this.driverConfig.startProfile(dc).withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, Arrays.asList(contactPoints))).endProfile();
        this.cqlOptions.put(dc, TypedDriverOption.CONTACT_POINTS, Arrays.asList(contactPoints));
        return this;
    }

    public StargateClientBuilder withCqlKeyspace(String keyspace) {
        Assert.hasLength((String)keyspace, (String)"keyspace");
        this.driverConfig.withString((DriverOption)DefaultDriverOption.SESSION_KEYSPACE, keyspace);
        this.cqlOptions.put(TypedDriverOption.SESSION_KEYSPACE, (Object)keyspace);
        return this;
    }

    public StargateClientBuilder withCqlCloudSecureConnectBundle(String cloudConfigUrl) {
        Assert.hasLength((String)cloudConfigUrl, (String)"cloudConfigUrl");
        this.driverConfig.withString((DriverOption)DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, cloudConfigUrl);
        this.cqlOptions.put(this.localDatacenter, TypedDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, (Object)cloudConfigUrl);
        return this;
    }

    public StargateClientBuilder withCqlCloudSecureConnectBundleDC(String dc, String cloudConfigUrl) {
        Assert.hasLength((String)cloudConfigUrl, (String)"cloudConfigUrl");
        this.driverConfig.withString((DriverOption)DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, cloudConfigUrl);
        this.cqlOptions.put(dc, TypedDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, (Object)cloudConfigUrl);
        return this;
    }

    public boolean isEnabledCql() {
        return this.enabledCql;
    }

    public CqlSession getCqlSession() {
        return this.cqlSession;
    }

    public OptionsMap getCqlOptions() {
        return this.cqlOptions;
    }

    public RequestTracker getCqlRequestTracker() {
        return this.cqlRequestTracker;
    }

    public ProgrammaticDriverConfigLoaderBuilder getCqlDriverConfigLoaderBuilder() {
        return this.driverConfig;
    }

    public Object getCqlMetricsRegistry() {
        return this.cqlMetricsRegistry;
    }

    private void checkNoCqlSession() {
        if (this.cqlSession != null) {
            throw new IllegalArgumentException("You cannot provide CqlOptions if a external CqlSession is used.");
        }
    }

    public StargateClientBuilder enableGrpc() {
        this.enabledGrpc = true;
        return this;
    }

    public boolean isEnabledGrpc() {
        return this.enabledGrpc;
    }

    public StargateClientBuilder withHttpRequestConfig(RequestConfig reqConfig) {
        Assert.notNull((Object)reqConfig, (String)"RequestConfig");
        this.httpRequestConfig = reqConfig;
        return this;
    }

    public StargateClientBuilder withHttpRetryConfig(RetryConfig retryConfig) {
        Assert.notNull((Object)retryConfig, (String)"retryConfig");
        this.httpRetryConfig = retryConfig;
        return this;
    }

    public StargateClientBuilder addHttpObserver(String name, ServiceCallObserver observer) {
        Assert.hasLength((String)name, (String)"Observer name");
        Assert.notNull((Object)observer, (String)"observer");
        if (this.httpObservers.containsKey(name)) {
            throw new IllegalArgumentException("An observer with the same name already exists (type=" + this.httpObservers.get(name).getClass().getName() + ")");
        }
        this.httpObservers.put(name, observer);
        return this;
    }

    public StargateClientBuilder withHttpObservers(Map<String, ServiceCallObserver> observers) {
        Assert.notNull(observers, (String)"observers");
        Assert.isTrue((Boolean)(observers.size() > 0 ? 1 : 0), (String)"observers should not be empty");
        this.httpObservers = observers;
        return this;
    }

    public RetryConfig getRetryConfig() {
        return this.httpRetryConfig;
    }

    public RequestConfig getRequestConfig() {
        return this.httpRequestConfig;
    }

    public Map<String, ServiceCallObserver> getObservers() {
        return this.httpObservers;
    }

    public StargateClient build() {
        return new StargateClient(this);
    }
}

